/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.tabular;

import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.tabular.AbstractHCBaseTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHCTable<IMPLTYPE extends AbstractHCTable<IMPLTYPE>>
extends AbstractHCBaseTable<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHCTable.class);

    public AbstractHCTable() {
        super(EHTMLElement.TABLE);
    }

    public AbstractHCTable(@Nullable IHCCol<?> iHCCol) {
        this();
        this.addColumn((IHCCol)iHCCol);
    }

    public AbstractHCTable(IHCCol<?> ... iHCColArray) {
        this();
        this.addColumns(iHCColArray);
    }

    public AbstractHCTable(@Nullable Iterable<? extends IHCCol<?>> iterable) {
        this();
        this.addColumns(iterable);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (iHCConversionSettingsToNode.getHTMLVersion().isPriorToHTML5()) {
            if (this.getCellSpacing() >= 0) {
                iMicroElement.setAttribute(CHTMLAttributes.CELLSPACING, this.getCellSpacing());
            }
            if (this.getCellPadding() >= 0) {
                iMicroElement.setAttribute(CHTMLAttributes.CELLPADDING, this.getCellPadding());
            }
        }
        if (this.getColGroup() != null && this.getColGroup().hasColumns()) {
            iMicroElement.appendChild(this.getColGroup().convertToMicroNode(iHCConversionSettingsToNode));
        }
        iMicroElement.appendChild(this.getHead().convertToMicroNode(iHCConversionSettingsToNode));
        iMicroElement.appendChild(this.getFoot().convertToMicroNode(iHCConversionSettingsToNode));
        iMicroElement.appendChild(this.getBody().convertToMicroNode(iHCConversionSettingsToNode));
    }
}

