/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.textlevel;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.HCHTMLHelper;
import com.helger.html.hc.html.HC_Target;
import com.helger.html.hc.html.textlevel.IHCA;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractHCA<IMPLTYPE extends AbstractHCA<IMPLTYPE>>
extends AbstractHCElementWithChildren<IMPLTYPE>
implements IHCA<IMPLTYPE> {
    private ISimpleURL m_aHref;
    private HC_Target m_aTarget;
    private String m_sName;
    private IMimeType m_aType;
    private String m_sMediaQuery;

    public AbstractHCA() {
        super(EHTMLElement.A);
    }

    public AbstractHCA(@Nonnull ISimpleURL iSimpleURL) {
        this();
        this.setHref(iSimpleURL);
    }

    @Override
    @Nullable
    public final ISimpleURL getHref() {
        return this.m_aHref;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHref(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull(iSimpleURL, "href");
        this.m_aHref = iSimpleURL;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final HC_Target getTarget() {
        return this.m_aTarget;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTarget(@Nullable HC_Target hC_Target) {
        this.m_aTarget = hC_Target;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setName(@Nullable String string) {
        this.m_sName = string;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setType(@Nullable IMimeType iMimeType) {
        this.m_aType = iMimeType;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getMedia() {
        return this.m_sMediaQuery;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMedia(@Nullable String string) {
        this.m_sMediaQuery = string;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.onConsistencyCheck(iHCConversionSettingsToNode);
        if (HCHTMLHelper.recursiveContainsChildWithTagName(this, EHTMLElement.A)) {
            HCConsistencyChecker.consistencyError("<A> may never contain other links!");
        }
        if (HCHTMLHelper.recursiveContainsChildWithTagName(this, EHTMLElement.SELECT)) {
            HCConsistencyChecker.consistencyError("<A> contains invalid child element!");
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_aHref != null) {
            String string = this.m_aHref.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset());
            iMicroElement.setAttribute(CHTMLAttributes.HREF, string);
        }
        if (this.m_aTarget != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TARGET, (IHasAttributeValue)this.m_aTarget);
        }
        if (StringHelper.hasText(this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        if (this.m_aType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        }
        if (StringHelper.hasText(this.m_sMediaQuery)) {
            iMicroElement.setAttribute(CHTMLAttributes.MEDIA, this.m_sMediaQuery);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).appendIfNotNull("href", this.m_aHref).appendIfNotNull("target", this.m_aTarget).appendIfNotNull("name", this.m_sName).appendIfNotNull("type", this.m_aType).appendIfNotNull("mediaQuery", this.m_sMediaQuery).getToString();
    }
}

