/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.textlevel;

import com.helger.commons.datetime.DateTimeFormatterCache;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.annotation.SinceHTML5;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.xml.microdom.IMicroElement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SinceHTML5
public class HCTime
extends AbstractHCElementWithChildren<HCTime> {
    public static final int LENGTH_YEAR = 4;
    public static final int LENGTH_MONTH = 2;
    public static final int LENGTH_DAY = 2;
    public static final int LENGTH_WEEKINYEAR = 2;
    public static final int LENGTH_HOUR = 2;
    public static final int LENGTH_MIN = 2;
    public static final int LENGTH_SEC = 2;
    private String m_sDatetime;

    public HCTime() {
        super(EHTMLElement.TIME);
    }

    @Nullable
    public final String getDatetime() {
        return this.m_sDatetime;
    }

    @Nonnull
    public final HCTime setAsMonth(@Nonnegative int n, @Nonnegative int n2) {
        this.m_sDatetime = StringHelper.getLeadingZero(n, 4) + "-" + StringHelper.getLeadingZero(n2, 2);
        return this;
    }

    @Nonnull
    public final HCTime setAsDate(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        this.m_sDatetime = StringHelper.getLeadingZero(n, 4) + "-" + StringHelper.getLeadingZero(n2, 2) + "-" + StringHelper.getLeadingZero(n3, 2);
        return this;
    }

    @Nonnull
    public final HCTime setAsDate(@Nonnull LocalDate localDate) {
        this.m_sDatetime = DateTimeFormatterCache.getDateTimeFormatterStrict("uuuu-MM-dd").format(localDate);
        return this;
    }

    @Nonnull
    public final HCTime setAsDate(@Nonnull Date date) {
        return this.setAsDate(TypeConverter.convert(date, LocalDate.class));
    }

    @Nonnull
    public final HCTime setAsYearlessDate(@Nonnegative int n, @Nonnegative int n2) {
        this.m_sDatetime = StringHelper.getLeadingZero(n, 2) + "-" + StringHelper.getLeadingZero(n2, 2);
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnegative int n, @Nonnegative int n2) {
        this.m_sDatetime = StringHelper.getLeadingZero(n, 2) + ":" + StringHelper.getLeadingZero(n2, 2);
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        this.m_sDatetime = StringHelper.getLeadingZero(n, 2) + ":" + StringHelper.getLeadingZero(n2, 2) + ":" + StringHelper.getLeadingZero(n3, 2);
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4) {
        this.m_sDatetime = StringHelper.getLeadingZero(n, 2) + ":" + StringHelper.getLeadingZero(n2, 2) + ":" + StringHelper.getLeadingZero(n3, 2) + "." + n4;
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnull LocalTime localTime) {
        this.m_sDatetime = DateTimeFormatterCache.getDateTimeFormatterStrict("HH:mm:ss").format(localTime);
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnull Date date) {
        return this.setAsTime(TypeConverter.convert(date, LocalTime.class));
    }

    @Nonnull
    public final HCTime setAsDateAndTime(@Nonnull LocalDateTime localDateTime) {
        this.m_sDatetime = DateTimeFormatterCache.getDateTimeFormatterStrict("uuuu-MM-dd'T'HH:mm:ss.SSSZZ").format(localDateTime);
        return this;
    }

    @Nonnull
    public final HCTime setAsDateAndTime(@Nonnull ZonedDateTime zonedDateTime) {
        return this.setAsDateAndTime(zonedDateTime.toLocalDateTime());
    }

    @Nonnull
    public final HCTime setAsTimezone(@CheckForSigned int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        this.m_sDatetime = (n2 < 0 ? "-" : "+") + StringHelper.getLeadingZero(MathHelper.abs(n2), 2) + ":" + StringHelper.getLeadingZero(MathHelper.abs(n3), 2);
        return this;
    }

    @Nonnull
    public final HCTime setAsWeekInYear(@Nonnegative int n, @Nonnegative int n2) {
        this.m_sDatetime = StringHelper.getLeadingZero(n, 4) + "-W" + StringHelper.getLeadingZero(n2, 2);
        return this;
    }

    @Nonnull
    public final HCTime setAsYear(@Nonnegative int n) {
        this.m_sDatetime = StringHelper.getLeadingZero(n, 4);
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.hasText(this.m_sDatetime)) {
            iMicroElement.setAttribute(CHTMLAttributes.DATETIME, this.m_sDatetime);
        }
    }
}

