/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.impl;

import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCTextNode;
import com.helger.html.hc.impl.AbstractHCNode;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroText;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCTextNode<IMPLTYPE extends AbstractHCTextNode<IMPLTYPE>>
extends AbstractHCNode
implements IHCTextNode<IMPLTYPE> {
    private String m_sText;
    private boolean m_bEscape = true;

    @Override
    @Nonnull
    public final String getText() {
        return this.m_sText;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setText(@Nullable String string) {
        this.m_sText = StringHelper.getNotNull(string);
        return (IMPLTYPE)((AbstractHCTextNode)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE prependText(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            this.m_sText = string + this.m_sText;
        }
        return (IMPLTYPE)((AbstractHCTextNode)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE appendText(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            this.m_sText = this.m_sText + string;
        }
        return (IMPLTYPE)((AbstractHCTextNode)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setEscape(boolean bl) {
        this.m_bEscape = bl;
        return (IMPLTYPE)((AbstractHCTextNode)this.thisAsT());
    }

    @Override
    public final boolean isEscape() {
        return this.m_bEscape;
    }

    @Override
    @Nonnull
    protected IMicroText internalConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return new MicroText(this.m_sText).setEscape(this.m_bEscape);
    }

    @Override
    @Nonnull
    public String getPlainText() {
        return this.m_sText;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("text", this.m_sText).append("escape", this.m_bEscape).getToString();
    }
}

