/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.IHCCustomizer;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.impl.AbstractHCCustomizer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class HCCustomizerList
extends AbstractHCCustomizer {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<IHCCustomizer> m_aList = new CommonsArrayList<IHCCustomizer>();

    public HCCustomizerList(IHCCustomizer ... iHCCustomizerArray) {
        if (iHCCustomizerArray != null) {
            for (IHCCustomizer iHCCustomizer : iHCCustomizerArray) {
                this.addCustomizer(iHCCustomizer);
            }
        }
    }

    public HCCustomizerList(@Nullable Iterable<? extends IHCCustomizer> iterable) {
        if (iterable != null) {
            for (IHCCustomizer iHCCustomizer : iterable) {
                this.addCustomizer(iHCCustomizer);
            }
        }
    }

    @Nonnull
    public HCCustomizerList addCustomizer(@Nonnull IHCCustomizer iHCCustomizer) {
        ValueEnforcer.notNull(iHCCustomizer, "Customizer");
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aList.add(iHCCustomizer));
        return this;
    }

    @Nonnull
    public EChange removeCustomizer(@Nullable IHCCustomizer iHCCustomizer) {
        return this.m_aRWLock.writeLockedGet(() -> this.m_aList.removeObject(iHCCustomizer));
    }

    @Nonnull
    public EChange removeAllCustomizersOfClass(@Nonnull Class<? extends IHCCustomizer> clazz) {
        ValueEnforcer.notNull(clazz, "CustomizerClass");
        return this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.UNCHANGED;
            for (IHCCustomizer iHCCustomizer : (ICommonsList)this.m_aList.getClone()) {
                if (!iHCCustomizer.getClass().equals(clazz) || !this.m_aList.remove(iHCCustomizer)) continue;
                eChange = EChange.CHANGED;
            }
            return eChange;
        });
    }

    @Nonnegative
    public int getCustomizerCount() {
        return this.m_aRWLock.readLockedInt(this.m_aList::size);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IHCCustomizer> getAllCustomizers() {
        return this.m_aRWLock.readLockedGet(this.m_aList::getClone);
    }

    @Override
    public void customizeNode(@Nonnull IHCNode iHCNode, @Nonnull EHTMLVersion eHTMLVersion, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        for (IHCCustomizer iHCCustomizer : this.getAllCustomizers()) {
            iHCCustomizer.customizeNode(iHCNode, eHTMLVersion, iHCHasChildrenMutable);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("List", this.m_aList).getToString();
    }
}

