/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.entity.EHTMLEntity;
import com.helger.html.entity.IHTMLEntity;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.impl.AbstractHCNode;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.MicroEntityReference;
import javax.annotation.Nonnull;

public class HCEntityNode
extends AbstractHCNode {
    private final IHTMLEntity m_aEntity;
    private final String m_sPlainText;

    public HCEntityNode(@Nonnull EHTMLEntity eHTMLEntity) {
        this(eHTMLEntity, eHTMLEntity.getCharString());
    }

    public HCEntityNode(@Nonnull IHTMLEntity iHTMLEntity, @Nonnull String string) {
        ValueEnforcer.notNull(iHTMLEntity, "Entity");
        ValueEnforcer.notNull(string, "PlainText");
        this.m_aEntity = iHTMLEntity;
        this.m_sPlainText = string;
    }

    @Nonnull
    public IHTMLEntity getEntity() {
        return this.m_aEntity;
    }

    @Override
    @Nonnull
    protected IMicroEntityReference internalConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return new MicroEntityReference(this.m_aEntity.getEntityName());
    }

    @Override
    @Nonnull
    public String getPlainText() {
        return this.m_sPlainText;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("entity", this.m_aEntity).append("plainText", this.m_sPlainText).getToString();
    }

    @Nonnull
    public static HCEntityNode newNBSP() {
        return new HCEntityNode(EHTMLEntity.nbsp, " ");
    }

    @Nonnull
    public static HCEntityNode newCopy() {
        return new HCEntityNode(EHTMLEntity.copy, "\u00a9");
    }

    @Nonnull
    public static HCEntityNode newEuro() {
        return new HCEntityNode(EHTMLEntity.euro, "\u20ac");
    }

    @Nonnull
    public static HCEntityNode newLeftArrow() {
        return new HCEntityNode(EHTMLEntity.larr, "<-");
    }

    @Nonnull
    public static HCEntityNode newRightArrow() {
        return new HCEntityNode(EHTMLEntity.rarr, "->");
    }

    @Nonnull
    public static HCEntityNode newUpArrow() {
        return new HCEntityNode(EHTMLEntity.uarr, "^");
    }

    @Nonnull
    public static HCEntityNode newDownArrow() {
        return new HCEntityNode(EHTMLEntity.darr, "v");
    }

    @Nonnull
    public static HCEntityNode newNDash() {
        return new HCEntityNode(EHTMLEntity.ndash, "-");
    }

    @Nonnull
    public static HCEntityNode newShy() {
        return new HCEntityNode(EHTMLEntity.shy, "");
    }

    @Nonnull
    public static HCEntityNode newPerMille() {
        return new HCEntityNode(EHTMLEntity.permil, "\u2030");
    }

    @Nonnull
    public static HCEntityNode times() {
        return new HCEntityNode(EHTMLEntity.times, "x");
    }
}

