/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.special;

import com.helger.collection.multimap.MultiLinkedHashMapLinkedHashSetBased;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.hc.special.IHCSpecialNodes;
import com.helger.html.hc.special.InlineCSSList;
import com.helger.html.js.CollectingJSCodeProvider;
import com.helger.html.js.IHasJSCode;
import com.helger.html.resource.css.ICSSCodeProvider;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractHCSpecialNodes<IMPLTYPE extends AbstractHCSpecialNodes<IMPLTYPE>>
implements IHCSpecialNodes,
IGenericImplTrait<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHCSpecialNodes.class);
    private final MultiLinkedHashMapLinkedHashSetBased<ICSSMediaList, String> m_aExternalCSSs = new MultiLinkedHashMapLinkedHashSetBased();
    private final InlineCSSList m_aInlineCSSBeforeExternal = new InlineCSSList();
    private final InlineCSSList m_aInlineCSSAfterExternal = new InlineCSSList();
    private final ICommonsOrderedSet<String> m_aExternalJSs = new CommonsLinkedHashSet<String>();
    private final CollectingJSCodeProvider m_aInlineJSBeforeExternal = new CollectingJSCodeProvider();
    private final CollectingJSCodeProvider m_aInlineJSAfterExternal = new CollectingJSCodeProvider();

    public void clear() {
        this.m_aExternalCSSs.clear();
        this.m_aInlineCSSBeforeExternal.clear();
        this.m_aInlineCSSAfterExternal.clear();
        this.m_aExternalJSs.clear();
        this.m_aInlineJSBeforeExternal.reset();
        this.m_aInlineJSAfterExternal.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aExternalCSSs.isEmpty() && this.m_aInlineCSSBeforeExternal.isEmpty() && this.m_aInlineCSSAfterExternal.isEmpty() && this.m_aExternalJSs.isEmpty() && this.m_aInlineJSBeforeExternal.isEmpty() && this.m_aInlineJSAfterExternal.isEmpty();
    }

    @Nonnull
    protected ICSSMediaList getSafeCSSMediaList(@Nullable ICSSMediaList iCSSMediaList) {
        if (iCSSMediaList != null && !iCSSMediaList.hasNoMediaOrAll()) {
            return iCSSMediaList;
        }
        return new CSSMediaList();
    }

    @Nonnull
    public IMPLTYPE addExternalCSS(@Nullable ICSSMediaList iCSSMediaList, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "CSSURI");
        ICSSMediaList iCSSMediaList2 = this.getSafeCSSMediaList(iCSSMediaList);
        if (this.m_aExternalCSSs.putSingle(iCSSMediaList2, string).isUnchanged()) {
            LOGGER.warn("Duplicate CSS URI '" + string + "' with media list '" + iCSSMediaList2 + "' ignored");
        }
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasExternalCSSs() {
        return !this.m_aExternalCSSs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<ICSSMediaList, ICommonsList<String>> getAllExternalCSSs() {
        CommonsLinkedHashMap<ICSSMediaList, ICommonsList<String>> commonsLinkedHashMap = new CommonsLinkedHashMap<ICSSMediaList, ICommonsList<String>>();
        for (Map.Entry entry : this.m_aExternalCSSs.entrySet()) {
            commonsLinkedHashMap.put(entry.getKey(), ((ICommonsOrderedSet)entry.getValue()).getCopyAsList());
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    public IMPLTYPE addInlineCSSBeforeExternal(@Nullable ICSSMediaList iCSSMediaList, @Nonnull CharSequence charSequence) {
        ValueEnforcer.notNull(charSequence, "InlineCSS");
        this.m_aInlineCSSBeforeExternal.addInlineCSS(iCSSMediaList, charSequence);
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasInlineCSSBeforeExternal() {
        return this.m_aInlineCSSBeforeExternal.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSCodeProvider> getAllInlineCSSBeforeExternal() {
        return this.m_aInlineCSSBeforeExternal.getAll();
    }

    @Nonnull
    public IMPLTYPE addInlineCSSAfterExternal(@Nullable ICSSMediaList iCSSMediaList, @Nonnull CharSequence charSequence) {
        ValueEnforcer.notNull(charSequence, "InlineCSS");
        this.m_aInlineCSSAfterExternal.addInlineCSS(iCSSMediaList, charSequence);
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasInlineCSSAfterExternal() {
        return this.m_aInlineCSSAfterExternal.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSCodeProvider> getAllInlineCSSAfterExternal() {
        return this.m_aInlineCSSAfterExternal.getAll();
    }

    @Nonnull
    public IMPLTYPE addExternalJS(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "JSURI");
        if (!this.m_aExternalJSs.add(string)) {
            LOGGER.warn("Duplicate JS URI '" + string + "' ignored");
        }
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasExternalJSs() {
        return this.m_aExternalJSs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllExternalJSs() {
        return this.m_aExternalJSs.getCopyAsList();
    }

    @Nonnull
    public IMPLTYPE addInlineJSBeforeExternal(@Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull(iHasJSCode, "InlineJS");
        this.m_aInlineJSBeforeExternal.appendFlattened(iHasJSCode);
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasInlineJSBeforeExternal() {
        return this.m_aInlineJSBeforeExternal.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CollectingJSCodeProvider getInlineJSBeforeExternal() {
        return this.m_aInlineJSBeforeExternal.getClone();
    }

    @Nonnull
    public IMPLTYPE addInlineJSAfterExternal(@Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull(iHasJSCode, "InlineJS");
        this.m_aInlineJSAfterExternal.appendFlattened(iHasJSCode);
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasInlineJSAfterExternal() {
        return this.m_aInlineJSAfterExternal.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CollectingJSCodeProvider getInlineJSAfterExternal() {
        return this.m_aInlineJSAfterExternal.getClone();
    }

    @Nonnull
    public IMPLTYPE addAll(@Nonnull IHCSpecialNodes iHCSpecialNodes) {
        ValueEnforcer.notNull(iHCSpecialNodes, "SpecialNodes");
        for (Map.Entry object : iHCSpecialNodes.getAllExternalCSSs().entrySet()) {
            for (String string : (ICommonsList)object.getValue()) {
                this.addExternalCSS((ICSSMediaList)object.getKey(), string);
            }
        }
        for (ICSSCodeProvider iCSSCodeProvider : iHCSpecialNodes.getAllInlineCSSBeforeExternal()) {
            this.addInlineCSSBeforeExternal(iCSSCodeProvider.getMediaList(), iCSSCodeProvider.getCSSCode());
        }
        for (ICSSCodeProvider iCSSCodeProvider : iHCSpecialNodes.getAllInlineCSSAfterExternal()) {
            this.addInlineCSSAfterExternal(iCSSCodeProvider.getMediaList(), iCSSCodeProvider.getCSSCode());
        }
        for (String string : iHCSpecialNodes.getAllExternalJSs()) {
            this.addExternalJS(string);
        }
        this.addInlineJSBeforeExternal(iHCSpecialNodes.getInlineJSBeforeExternal());
        this.addInlineJSAfterExternal(iHCSpecialNodes.getInlineJSAfterExternal());
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractHCSpecialNodes abstractHCSpecialNodes = (AbstractHCSpecialNodes)object;
        return this.m_aExternalCSSs.equals(abstractHCSpecialNodes.m_aExternalCSSs) && EqualsHelper.equals(this.m_aInlineCSSBeforeExternal, abstractHCSpecialNodes.m_aInlineCSSBeforeExternal) && EqualsHelper.equals(this.m_aInlineCSSAfterExternal, abstractHCSpecialNodes.m_aInlineCSSAfterExternal) && this.m_aExternalJSs.equals(abstractHCSpecialNodes.m_aExternalJSs) && this.m_aInlineJSBeforeExternal.equals(abstractHCSpecialNodes.m_aInlineJSBeforeExternal) && this.m_aInlineJSAfterExternal.equals(abstractHCSpecialNodes.m_aInlineJSAfterExternal);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aExternalCSSs)).append(this.m_aInlineCSSBeforeExternal).append(this.m_aInlineCSSAfterExternal).append(this.m_aExternalJSs)).append(this.m_aInlineJSBeforeExternal).append(this.m_aInlineJSAfterExternal).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIf("externalCSS", this.m_aExternalCSSs, CollectionHelper::isNotEmpty).append("inlineCSSBeforeExternal", this.m_aInlineCSSBeforeExternal).append("inlineCSSAfterExternal", this.m_aInlineCSSAfterExternal).appendIf("externalJS", this.m_aExternalJSs, CollectionHelper::isNotEmpty).append("inlineJSBeforeExternal", this.m_aInlineJSBeforeExternal).append("inlineJSAfterExternal", this.m_aInlineJSBeforeExternal).getToString();
    }
}

