/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.js.CollectingJSCodeProvider;
import com.helger.html.js.EJSEvent;
import com.helger.html.js.IHasJSCode;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JSEventMap
implements Serializable {
    private final ICommonsMap<EJSEvent, CollectingJSCodeProvider> m_aEvents = new CommonsEnumMap<EJSEvent, CollectingJSCodeProvider>(EJSEvent.class);

    public void addHandler(@Nonnull EJSEvent eJSEvent, @Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull(eJSEvent, "JSEvent");
        ValueEnforcer.notNull(iHasJSCode, "NewHandler");
        CollectingJSCodeProvider collectingJSCodeProvider = (CollectingJSCodeProvider)this.m_aEvents.get((Object)eJSEvent);
        if (collectingJSCodeProvider == null) {
            collectingJSCodeProvider = new CollectingJSCodeProvider();
            this.m_aEvents.put(eJSEvent, collectingJSCodeProvider);
        }
        collectingJSCodeProvider.appendFlattened(iHasJSCode);
    }

    public void prependHandler(@Nonnull EJSEvent eJSEvent, @Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull(eJSEvent, "JSEvent");
        ValueEnforcer.notNull(iHasJSCode, "NewHandler");
        CollectingJSCodeProvider collectingJSCodeProvider = (CollectingJSCodeProvider)this.m_aEvents.get((Object)eJSEvent);
        if (collectingJSCodeProvider == null) {
            collectingJSCodeProvider = new CollectingJSCodeProvider();
            this.m_aEvents.put(eJSEvent, collectingJSCodeProvider);
        }
        collectingJSCodeProvider.prepend(iHasJSCode);
    }

    public void setHandler(@Nonnull EJSEvent eJSEvent, @Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull(eJSEvent, "JSEvent");
        ValueEnforcer.notNull(iHasJSCode, "NewHandler");
        this.m_aEvents.put(eJSEvent, new CollectingJSCodeProvider().appendFlattened(iHasJSCode));
    }

    @Nonnull
    public EChange removeHandler(@Nullable EJSEvent eJSEvent) {
        if (eJSEvent == null) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf(this.m_aEvents.remove((Object)eJSEvent) != null);
    }

    @Nullable
    public CollectingJSCodeProvider getHandler(@Nullable EJSEvent eJSEvent) {
        return eJSEvent == null ? null : (CollectingJSCodeProvider)this.m_aEvents.get((Object)eJSEvent);
    }

    public boolean containsHandler(@Nullable EJSEvent eJSEvent) {
        return eJSEvent != null && this.m_aEvents.containsKey((Object)eJSEvent);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EJSEvent, CollectingJSCodeProvider> getAllEventHandler() {
        return (ICommonsMap)this.m_aEvents.getClone();
    }

    public String toString() {
        return new ToStringGenerator(this).append("events", this.m_aEvents).getToString();
    }
}

