/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JSFilenameHelper {
    private static final String JS_IN_URL = ".js?";
    private static final String JS_IN_URL2 = ".js#";
    private static final String MIN_JS_IN_URL = ".min.js?";
    private static final String MIN_JS_IN_URL2 = ".min.js#";

    private JSFilenameHelper() {
    }

    public static boolean isJSFilename(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return string.endsWith(".js") || string.contains(JS_IN_URL) || string.contains(JS_IN_URL2);
    }

    public static boolean isMinifiedJSFilename(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return string.endsWith(".min.js") || string.contains(MIN_JS_IN_URL) || string.contains(MIN_JS_IN_URL2);
    }

    public static boolean isRegularJSFilename(@Nullable String string) {
        return JSFilenameHelper.isJSFilename(string) && !JSFilenameHelper.isMinifiedJSFilename(string);
    }

    @Nonnull
    public static String getMinifiedJSFilename(@Nonnull String string) {
        if (!JSFilenameHelper.isJSFilename(string)) {
            throw new IllegalArgumentException("Passed file name '" + string + "' is not a JS file name!");
        }
        if (JSFilenameHelper.isMinifiedJSFilename(string)) {
            return string;
        }
        return string.replace(".js", ".min.js");
    }
}

