/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.system.ENewLineMode;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JSWriterDefaultSettings {
    public static final boolean DEFAULT_INDENT_AND_ALIGN = true;
    public static final boolean DEFAULT_GENERATE_TYPE_NAMES = false;
    public static final boolean DEFAULT_GENERATE_COMMENTS = false;
    public static final String DEFAULT_INDENT = "  ";
    private static boolean s_bIndentAndAlign = true;
    private static boolean s_bGenerateTypeNames = false;
    private static boolean s_bGenerateComments = false;
    private static String s_sIndent = "  ";
    private static ENewLineMode s_eNewLineMode = ENewLineMode.DEFAULT;

    private JSWriterDefaultSettings() {
    }

    public static void setToDefault() {
        s_bIndentAndAlign = true;
        s_bGenerateTypeNames = false;
        s_bGenerateComments = false;
        s_sIndent = DEFAULT_INDENT;
        s_eNewLineMode = ENewLineMode.DEFAULT;
    }

    public static void setIndentAndAlign(boolean bl) {
        s_bIndentAndAlign = bl;
    }

    public static boolean isIndentAndAlign() {
        return s_bIndentAndAlign;
    }

    public static void setGenerateTypeNames(boolean bl) {
        s_bGenerateTypeNames = bl;
    }

    public static boolean isGenerateTypeNames() {
        return s_bGenerateTypeNames;
    }

    public static void setGenerateComments(boolean bl) {
        s_bGenerateComments = bl;
    }

    public static boolean isGenerateComments() {
        return s_bGenerateComments;
    }

    public static void setMinimumCodeSize(boolean bl) {
        JSWriterDefaultSettings.setIndentAndAlign(!bl);
        JSWriterDefaultSettings.setGenerateTypeNames(!bl);
        JSWriterDefaultSettings.setGenerateComments(!bl);
    }

    public static void setIndent(@Nonnull @Nonempty String string) {
        s_sIndent = ValueEnforcer.notEmpty(string, "Indent");
    }

    @Nonnull
    @Nonempty
    public static String getIndent() {
        return s_sIndent;
    }

    public static void setNewLineMode(@Nonnull ENewLineMode eNewLineMode) {
        s_eNewLineMode = ValueEnforcer.notNull(eNewLineMode, "NewLineMode");
    }

    @Nonnull
    public static ENewLineMode getNewLineMode() {
        return s_eNewLineMode;
    }
}

