/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.js.IHasJSCode;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnparsedJSCodeProvider
implements IHasJSCode {
    private final String m_sJSCode;

    public UnparsedJSCodeProvider(@Nonnull String string) {
        this.m_sJSCode = ValueEnforcer.notNull(string, "JSCode");
    }

    @Override
    @Nonnull
    public String getJSCode() {
        return this.m_sJSCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        UnparsedJSCodeProvider unparsedJSCodeProvider = (UnparsedJSCodeProvider)object;
        return this.m_sJSCode.equals(unparsedJSCodeProvider.m_sJSCode);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sJSCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("jsCode", this.m_sJSCode).getToString();
    }
}

