/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js.tostring;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.js.tostring.EJSType;
import com.helger.html.js.tostring.IHasChildJSType;
import com.helger.html.js.tostring.JSType;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JSArrayType
extends JSType
implements IHasChildJSType {
    private final JSType m_aChildType;

    public JSArrayType(@Nonnull JSType jSType) {
        super(EJSType.ARRAY);
        this.m_aChildType = ValueEnforcer.notNull(jSType, "ChildType");
    }

    @Override
    @Nonnull
    public JSType getChildType() {
        return this.m_aChildType;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSArrayType jSArrayType = (JSArrayType)object;
        return this.m_aChildType.equals(jSArrayType.m_aChildType);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aChildType).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("childType", this.m_aChildType).getToString();
    }
}

