/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js.tostring;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.js.tostring.EJSType;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class JSType
implements Serializable {
    public static final JSType AUTO_DETECT = new JSType();
    public static final JSType HTML = new JSType(EJSType.HTML);
    public static final JSType STRING = new JSType(EJSType.STRING);
    public static final JSType INT = new JSType(EJSType.INT);
    public static final JSType DOUBLE = new JSType(EJSType.DOUBLE);
    public static final JSType BOOLEAN = new JSType(EJSType.BOOLEAN);
    public static final JSType VOID = new JSType(EJSType.VOID);
    public static final JSType JS = new JSType(EJSType.JS);
    public static final JSType JSON = new JSType(EJSType.JSON);
    private final EJSType m_eType;

    private JSType() {
        this.m_eType = null;
    }

    protected JSType(@Nonnull EJSType eJSType) {
        this.m_eType = ValueEnforcer.notNull(eJSType, "Type");
    }

    @Nullable
    public final EJSType getType() {
        return this.m_eType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSType jSType = (JSType)object;
        return EqualsHelper.equals((Object)this.m_eType, (Object)jSType.m_eType);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eType)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("jsType", this.m_eType).getToString();
    }
}

