/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.markdown;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.html.markdown.EBlockType;
import com.helger.html.markdown.Line;
import javax.annotation.Nonnull;

@CodingStyleguideUnaware
final class Block {
    public EBlockType m_eType = EBlockType.NONE;
    public Line m_aLines;
    public Line m_aLineTail;
    public Block m_aBlocks;
    public Block m_aBlockTail;
    public Block m_aNext;
    public int m_nHeadlineDepth = 0;
    public String m_sID;
    public String m_sMeta = "";

    public boolean hasLines() {
        return this.m_aLines != null;
    }

    public void removeSurroundingEmptyLines() {
        if (this.m_aLines != null) {
            this.removeTrailingEmptyLines();
            this.removeLeadingEmptyLines();
        }
    }

    public void transfromHeadline() {
        int n;
        if (this.m_nHeadlineDepth > 0) {
            return;
        }
        int n2 = 0;
        Line line = this.m_aLines;
        if (line.m_bIsEmpty) {
            return;
        }
        for (n = line.m_nLeading; n < line.m_sValue.length() && line.m_sValue.charAt(n) == '#'; ++n) {
            ++n2;
        }
        while (n < line.m_sValue.length() && line.m_sValue.charAt(n) == ' ') {
            ++n;
        }
        if (n >= line.m_sValue.length()) {
            line.setEmpty();
        } else {
            int n3 = line.m_sValue.length() - line.m_nTrailing - 1;
            while (line.m_sValue.charAt(n3) == '#') {
                --n3;
            }
            while (line.m_sValue.charAt(n3) == ' ') {
                --n3;
            }
            line.m_sValue = line.m_sValue.substring(n, n3 + 1);
            line.m_nTrailing = 0;
            line.m_nLeading = 0;
        }
        this.m_nHeadlineDepth = Math.min(n2, 6);
    }

    public void removeListIndent(boolean bl) {
        Line line = this.m_aLines;
        while (line != null) {
            if (!line.m_bIsEmpty) {
                switch (line.getLineType(bl)) {
                    case ULIST: {
                        line.m_sValue = line.m_sValue.substring(line.m_nLeading + 2);
                        break;
                    }
                    case OLIST: {
                        line.m_sValue = line.m_sValue.substring(line.m_sValue.indexOf(46) + 2);
                        break;
                    }
                    default: {
                        line.m_sValue = line.m_sValue.substring(Math.min(line.m_nLeading, 4));
                    }
                }
                line.initLeading();
            }
            line = line.m_aNext;
        }
    }

    public void removeBlockQuotePrefix() {
        Line line = this.m_aLines;
        while (line != null) {
            if (!line.m_bIsEmpty && line.m_sValue.charAt(line.m_nLeading) == '>') {
                int n = line.m_nLeading + 1;
                if (line.m_nLeading + 1 < line.m_sValue.length() && line.m_sValue.charAt(line.m_nLeading + 1) == ' ') {
                    ++n;
                }
                line.m_sValue = line.m_sValue.substring(n);
                line.initLeading();
            }
            line = line.m_aNext;
        }
    }

    public boolean removeLeadingEmptyLines() {
        boolean bl = false;
        Line line = this.m_aLines;
        while (line != null && line.m_bIsEmpty) {
            this.removeLine(line);
            line = this.m_aLines;
            bl = true;
        }
        return bl;
    }

    public void removeTrailingEmptyLines() {
        Line line = this.m_aLineTail;
        while (line != null && line.m_bIsEmpty) {
            this.removeLine(line);
            line = this.m_aLineTail;
        }
    }

    public Block split(Line line) {
        Block block = new Block();
        block.m_aLines = this.m_aLines;
        block.m_aLineTail = line;
        this.m_aLines = line.m_aNext;
        line.m_aNext = null;
        if (this.m_aLines == null) {
            this.m_aLineTail = null;
        } else {
            this.m_aLines.m_aPrevious = null;
        }
        if (this.m_aBlocks == null) {
            this.m_aBlocks = this.m_aBlockTail = block;
        } else {
            this.m_aBlockTail.m_aNext = block;
            this.m_aBlockTail = block;
        }
        return block;
    }

    public void removeLine(Line line) {
        if (line.m_aPrevious == null) {
            this.m_aLines = line.m_aNext;
        } else {
            line.m_aPrevious.m_aNext = line.m_aNext;
        }
        if (line.m_aNext == null) {
            this.m_aLineTail = line.m_aPrevious;
        } else {
            line.m_aNext.m_aPrevious = line.m_aPrevious;
        }
        line.m_aPrevious = null;
        line.m_aNext = null;
    }

    public void appendLine(@Nonnull Line line) {
        if (this.m_aLineTail == null) {
            this.m_aLines = line;
            this.m_aLineTail = line;
        } else {
            line.m_bPrevEmpty = this.m_aLineTail.m_bIsEmpty;
            line.m_aPrevious = this.m_aLineTail;
            this.m_aLineTail.m_aNext = line;
            this.m_aLineTail = line;
        }
    }

    public void expandListParagraphs() {
        Block block;
        if (this.m_eType != EBlockType.ORDERED_LIST && this.m_eType != EBlockType.UNORDERED_LIST) {
            return;
        }
        Block block2 = this.m_aBlocks;
        boolean bl = false;
        while (block2 != null && !bl) {
            if (block2.m_eType == EBlockType.LIST_ITEM) {
                block = block2.m_aBlocks;
                while (block != null && !bl) {
                    if (block.m_eType == EBlockType.PARAGRAPH) {
                        bl = true;
                    }
                    block = block.m_aNext;
                }
            }
            block2 = block2.m_aNext;
        }
        if (bl) {
            block2 = this.m_aBlocks;
            while (block2 != null) {
                if (block2.m_eType == EBlockType.LIST_ITEM) {
                    block = block2.m_aBlocks;
                    while (block != null) {
                        if (block.m_eType == EBlockType.NONE) {
                            block.m_eType = EBlockType.PARAGRAPH;
                        }
                        block = block.m_aNext;
                    }
                }
                block2 = block2.m_aNext;
            }
        }
    }
}

