/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.markdown;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.NonBlockingStack;
import com.helger.commons.string.StringHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.IHCNodeWithChildren;
import com.helger.html.hc.html.IHCMediaElementChild;
import com.helger.html.hc.html.embedded.IHCMediaElement;
import com.helger.html.hc.html.forms.HCOptGroup;
import com.helger.html.hc.html.forms.HCOption;
import com.helger.html.hc.html.grouping.HCDL;
import com.helger.html.hc.html.grouping.HCLI;
import com.helger.html.hc.html.grouping.IHCDefinitionItem;
import com.helger.html.hc.html.grouping.IHCList;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCColGroup;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTBody;
import com.helger.html.hc.html.tabular.HCTFoot;
import com.helger.html.hc.html.tabular.HCTHead;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.tabular.IHCTablePart;
import com.helger.html.hc.html.textlevel.HCRuby;
import com.helger.html.hc.html.textlevel.IHCRubyChild;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.html.markdown.MarkdownException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class MarkdownHCStack {
    private final NonBlockingStack<IHCNode> m_aStack = new NonBlockingStack();

    public MarkdownHCStack() {
        this.m_aStack.push(new HCNodeList());
    }

    public void push(@Nonnull IHCNode iHCNode) {
        this.append(iHCNode);
        this.m_aStack.push(iHCNode);
    }

    @Nonnull
    public <T extends IHCNodeWithChildren<T>> T push(@Nonnull T t) {
        this.append(t);
        this.m_aStack.push(t);
        return t;
    }

    public void pop() {
        if (this.m_aStack.size() == 1) {
            throw new MarkdownException("Can't pop from empty stack");
        }
        this.m_aStack.pop();
    }

    @Nonnull
    public HCNodeList getRoot() {
        return (HCNodeList)this.m_aStack.get(0);
    }

    public void reset() {
        this.m_aStack.clear();
        this.m_aStack.push(new HCNodeList());
    }

    public void append(char c) {
        this.append(new HCTextNode(c));
    }

    public void append(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            this.append(new HCTextNode(string));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(@Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull(iHCNode, "Node");
        IHCNode iHCNode2 = this.m_aStack.peek();
        if (iHCNode2 instanceof IHCList && iHCNode instanceof HCLI) {
            ((IHCList)iHCNode2).addItem(iHCNode);
            return;
        } else if (iHCNode2 instanceof IHCMediaElement && iHCNode instanceof IHCMediaElementChild) {
            ((IHCMediaElement)iHCNode2).addChild((IHCMediaElementChild)iHCNode);
            return;
        } else if (iHCNode2 instanceof HCColGroup && iHCNode instanceof HCCol) {
            ((HCColGroup)iHCNode2).addChild((HCCol)iHCNode);
            return;
        } else if (iHCNode2 instanceof HCDL && iHCNode instanceof IHCDefinitionItem) {
            ((HCDL)iHCNode2).addChild((IHCDefinitionItem)iHCNode);
            return;
        } else if (iHCNode2 instanceof HCOptGroup && iHCNode instanceof HCOption) {
            ((HCOptGroup)iHCNode2).addChild((HCOption)iHCNode);
            return;
        } else if (iHCNode2 instanceof HCOption && iHCNode instanceof HCTextNode) {
            ((HCOption)iHCNode2).addChild((HCTextNode)iHCNode);
            return;
        } else if (iHCNode2 instanceof IHCTable) {
            if (iHCNode instanceof HCTHead) {
                ((IHCTable)iHCNode2).setHead((HCTHead)iHCNode);
                return;
            } else if (iHCNode instanceof HCTBody) {
                ((IHCTable)iHCNode2).setBody((HCTBody)iHCNode);
                return;
            } else if (iHCNode instanceof HCTFoot) {
                ((IHCTable)iHCNode2).setFoot((HCTFoot)iHCNode);
                return;
            } else {
                if (!(iHCNode instanceof HCRow)) throw new MarkdownException("Cannot add node " + iHCNode + " to " + iHCNode2);
                ((IHCTable)iHCNode2).addBodyRow((HCRow)iHCNode);
            }
            return;
        } else if (iHCNode2 instanceof IHCTablePart && iHCNode instanceof HCRow) {
            ((IHCTablePart)iHCNode2).addChild((HCRow)iHCNode);
            return;
        } else if (iHCNode2 instanceof HCRow && iHCNode instanceof IHCCell) {
            ((HCRow)iHCNode2).addCell(iHCNode);
            return;
        } else if (iHCNode2 instanceof HCRuby && iHCNode instanceof IHCRubyChild) {
            ((HCRuby)iHCNode2).addChild((IHCRubyChild)iHCNode);
            return;
        } else {
            if (!(iHCNode2 instanceof IHCNodeWithChildren)) throw new MarkdownException("Cannot add node " + iHCNode + " to " + iHCNode2);
            IHCNodeWithChildren iHCNodeWithChildren = (IHCNodeWithChildren)iHCNode2;
            if (iHCNode instanceof HCTextNode && iHCNodeWithChildren.getLastChild() instanceof HCTextNode) {
                ((HCTextNode)iHCNodeWithChildren.getLastChild()).appendText(((HCTextNode)iHCNode).getText());
                return;
            } else {
                iHCNodeWithChildren.addChild(iHCNode);
            }
        }
    }
}

