/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.meta;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.meta.IMetaElement;
import com.helger.html.meta.IMetaElementList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MetaElementList
implements ICloneable<MetaElementList>,
IMetaElementList {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedMap<String, IMetaElement> m_aItems = new CommonsLinkedHashMap<String, IMetaElement>();

    public MetaElementList() {
    }

    public MetaElementList(@Nonnull MetaElementList metaElementList) {
        ValueEnforcer.notNull(metaElementList, "Other");
        this.m_aItems.putAll(metaElementList.m_aItems);
    }

    public MetaElementList(@Nonnull Iterable<? extends IMetaElement> iterable) {
        ValueEnforcer.notNull(iterable, "MetaElementList");
        for (IMetaElement iMetaElement : iterable) {
            this.addMetaElement(iMetaElement);
        }
    }

    @Nonnull
    public MetaElementList addMetaElement(@Nonnull IMetaElement iMetaElement) {
        ValueEnforcer.notNull(iMetaElement, "MetaElement");
        this.m_aRWLock.writeLockedGet(() -> this.m_aItems.put(iMetaElement.getName(), iMetaElement));
        return this;
    }

    @Nonnull
    public MetaElementList addMetaElements(@Nonnull Iterable<? extends IMetaElement> iterable) {
        ValueEnforcer.notNull(iterable, "MetaElementList");
        for (IMetaElement iMetaElement : iterable) {
            this.addMetaElement(iMetaElement);
        }
        return this;
    }

    @Nonnull
    public MetaElementList addMetaElements(@Nonnull MetaElementList metaElementList) {
        ValueEnforcer.notNull(metaElementList, "MetaElementList");
        this.m_aRWLock.writeLocked(() -> this.m_aItems.putAll(metaElementList.m_aItems));
        return this;
    }

    @Nonnull
    public EChange removeMetaElement(@Nullable String string) {
        return this.m_aRWLock.writeLockedGet(() -> this.m_aItems.removeObject(string));
    }

    @Nonnull
    public EChange removeAllMetaElements() {
        return this.m_aRWLock.writeLockedGet(this.m_aItems::removeAll);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllMetaElementNames() {
        return this.m_aRWLock.readLockedGet(this.m_aItems::copyOfKeySet);
    }

    @Override
    public void getAllMetaElements(@Nonnull Collection<? super IMetaElement> collection) {
        ValueEnforcer.notNull(collection, "Target");
        this.m_aRWLock.readLockedBoolean(() -> collection.addAll(this.m_aItems.values()));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMetaElement> getAllMetaElements() {
        return this.m_aRWLock.readLockedGet(this.m_aItems::copyOfValues);
    }

    @Override
    @Nullable
    public IMetaElement getMetaElementOfName(@Nullable String string) {
        return this.m_aRWLock.readLockedGet(() -> (IMetaElement)this.m_aItems.get(string));
    }

    @Override
    public boolean containsMetaElementWithName(@Nullable String string) {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aItems.containsKey(string));
    }

    @Override
    @Nonnegative
    public int getMetaElementCount() {
        return this.m_aRWLock.readLockedInt(this.m_aItems::size);
    }

    @Override
    public boolean hasMetaElements() {
        return this.m_aRWLock.readLockedBoolean(this.m_aItems::isNotEmpty);
    }

    @Override
    @Nonnull
    public Iterator<IMetaElement> iterator() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aItems.values().iterator());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MetaElementList getClone() {
        return this.m_aRWLock.readLockedGet(() -> new MetaElementList(this));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MetaElementList metaElementList = (MetaElementList)object;
        return this.m_aItems.equals(metaElementList.m_aItems);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aItems)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("items", this.m_aItems).getToString();
    }
}

