/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.resource.css;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.resource.css.ICSSCodeProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConstantCSSCodeProvider
implements ICSSCodeProvider {
    private final String m_sCSSCode;
    private final String m_sConditionalComment;
    private final CSSMediaList m_aCSSMediaList;
    private final boolean m_bIsBundlable;

    public ConstantCSSCodeProvider(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable ICSSMediaList iCSSMediaList, boolean bl) {
        ValueEnforcer.notEmpty(string, "CSSCode");
        this.m_sCSSCode = string;
        this.m_sConditionalComment = string2;
        this.m_aCSSMediaList = iCSSMediaList == null ? new CSSMediaList() : new CSSMediaList(iCSSMediaList);
        this.m_bIsBundlable = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getCSSCode() {
        return this.m_sCSSCode;
    }

    @Override
    @Nullable
    public String getConditionalComment() {
        return this.m_sConditionalComment;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICSSMediaList getMediaList() {
        return this.m_aCSSMediaList.getClone();
    }

    @Override
    public boolean isBundlable() {
        return this.m_bIsBundlable;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ConstantCSSCodeProvider constantCSSCodeProvider = (ConstantCSSCodeProvider)object;
        return this.m_sCSSCode.equals(constantCSSCodeProvider.m_sCSSCode) && this.m_bIsBundlable == constantCSSCodeProvider.m_bIsBundlable;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sCSSCode).append(this.m_bIsBundlable).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("CSSCode", this.m_sCSSCode).appendIfNotNull("conditionalComment", this.m_sConditionalComment).appendIfNotNull("CSSMediaList", this.m_aCSSMediaList).append("isBundlable", this.m_bIsBundlable).getToString();
    }

    @Nonnull
    public static ConstantCSSCodeProvider create(@Nonnull @Nonempty String string) {
        return new ConstantCSSCodeProvider(string, DEFAULT_CONDITIONAL_COMMENT, DEFAULT_CSS_MEDIA_LIST, true);
    }

    @Nonnull
    public static ConstantCSSCodeProvider createWithConditionalComment(@Nonnull @Nonempty String string, @Nullable String string2) {
        return ConstantCSSCodeProvider.createWithConditionalComment(string, string2, DEFAULT_CSS_MEDIA_LIST);
    }

    @Nonnull
    public static ConstantCSSCodeProvider createWithConditionalComment(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable ICSSMediaList iCSSMediaList) {
        return new ConstantCSSCodeProvider(string, string2, iCSSMediaList, true);
    }

    @Nonnull
    public static ConstantCSSCodeProvider createBundlable(@Nonnull @Nonempty String string, boolean bl) {
        return ConstantCSSCodeProvider.createBundlable(string, DEFAULT_CSS_MEDIA_LIST, bl);
    }

    @Nonnull
    public static ConstantCSSCodeProvider createBundlable(@Nonnull @Nonempty String string, @Nullable ICSSMediaList iCSSMediaList, boolean bl) {
        return new ConstantCSSCodeProvider(string, DEFAULT_CONDITIONAL_COMMENT, iCSSMediaList, bl);
    }
}

