/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.resource.css;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSFilenameHelper;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.resource.css.ICSSPathProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConstantCSSPathProvider
implements ICSSPathProvider {
    private final String m_sPath;
    private final String m_sMinifiedPath;
    private final String m_sConditionalComment;
    private final CSSMediaList m_aCSSMediaList;
    private final boolean m_bIsBundlable;

    public ConstantCSSPathProvider(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable ICSSMediaList iCSSMediaList, boolean bl) {
        ValueEnforcer.notEmpty(string, "Path");
        ValueEnforcer.isTrue(CSSFilenameHelper.isCSSFilename(string), "path");
        ValueEnforcer.notEmpty(string2, "MinifiedPath");
        ValueEnforcer.isTrue(CSSFilenameHelper.isCSSFilename(string2), "minified path");
        this.m_sPath = string;
        this.m_sMinifiedPath = string2;
        this.m_sConditionalComment = string3;
        this.m_aCSSMediaList = iCSSMediaList == null ? new CSSMediaList() : new CSSMediaList(iCSSMediaList);
        this.m_bIsBundlable = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getCSSItemPath(boolean bl) {
        return bl ? this.m_sPath : this.m_sMinifiedPath;
    }

    @Override
    @Nullable
    public String getConditionalComment() {
        return this.m_sConditionalComment;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICSSMediaList getMediaList() {
        return this.m_aCSSMediaList.getClone();
    }

    @Override
    public boolean isBundlable() {
        return this.m_bIsBundlable;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ConstantCSSPathProvider constantCSSPathProvider = (ConstantCSSPathProvider)object;
        return this.m_sPath.equals(constantCSSPathProvider.m_sPath) && this.m_sMinifiedPath.equals(constantCSSPathProvider.m_sMinifiedPath) && this.m_bIsBundlable == constantCSSPathProvider.m_bIsBundlable;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPath).append(this.m_sMinifiedPath).append(this.m_bIsBundlable).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("path", this.m_sPath).append("minifiedPath", this.m_sMinifiedPath).appendIfNotNull("conditionalComment", this.m_sConditionalComment).appendIfNotNull("CSSMediaList", this.m_aCSSMediaList).append("isBundlable", this.m_bIsBundlable).getToString();
    }

    @Nonnull
    public static ConstantCSSPathProvider create(@Nonnull @Nonempty String string) {
        return new ConstantCSSPathProvider(string, CSSFilenameHelper.getMinifiedCSSFilename(string), DEFAULT_CONDITIONAL_COMMENT, DEFAULT_CSS_MEDIA_LIST, true);
    }

    @Nonnull
    public static ConstantCSSPathProvider createWithConditionalComment(@Nonnull @Nonempty String string, @Nullable String string2) {
        return ConstantCSSPathProvider.createWithConditionalComment(string, string2, DEFAULT_CSS_MEDIA_LIST);
    }

    @Nonnull
    public static ConstantCSSPathProvider createWithConditionalComment(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable ICSSMediaList iCSSMediaList) {
        return new ConstantCSSPathProvider(string, CSSFilenameHelper.getMinifiedCSSFilename(string), string2, iCSSMediaList, true);
    }

    @Nonnull
    public static ConstantCSSPathProvider createBundlable(@Nonnull @Nonempty String string, boolean bl) {
        return ConstantCSSPathProvider.createBundlable(string, DEFAULT_CSS_MEDIA_LIST, bl);
    }

    @Nonnull
    public static ConstantCSSPathProvider createBundlable(@Nonnull @Nonempty String string, @Nullable ICSSMediaList iCSSMediaList, boolean bl) {
        return new ConstantCSSPathProvider(string, CSSFilenameHelper.getMinifiedCSSFilename(string), DEFAULT_CONDITIONAL_COMMENT, iCSSMediaList, bl);
    }

    @Nonnull
    public static ConstantCSSPathProvider createExternal(@Nonnull @Nonempty String string) {
        return ConstantCSSPathProvider.createExternal(string, DEFAULT_CONDITIONAL_COMMENT, DEFAULT_CSS_MEDIA_LIST);
    }

    @Nonnull
    public static ConstantCSSPathProvider createExternal(@Nonnull @Nonempty String string, @Nullable String string2) {
        return ConstantCSSPathProvider.createExternal(string, string2, DEFAULT_CSS_MEDIA_LIST);
    }

    @Nonnull
    public static ConstantCSSPathProvider createExternal(@Nonnull @Nonempty String string, @Nullable ICSSMediaList iCSSMediaList) {
        return ConstantCSSPathProvider.createExternal(string, DEFAULT_CONDITIONAL_COMMENT, iCSSMediaList);
    }

    @Nonnull
    public static ConstantCSSPathProvider createExternal(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable ICSSMediaList iCSSMediaList) {
        return new ConstantCSSPathProvider(string, string, string2, iCSSMediaList, false);
    }
}

