/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.http.AcceptEncodingList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AcceptEncodingHandler {
    public static final String ANY_ENCODING = "*";
    public static final String IDENTITY_ENCODING = "identity";
    public static final String GZIP_ENCODING = "gzip";
    public static final String X_GZIP_ENCODING = "x-gzip";
    public static final String DEFLATE_ENCODING = "deflate";
    public static final String COMPRESS_ENCODING = "compress";
    public static final String X_COMPRESS_ENCODING = "x-compress";
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptEncodingHandler.class);
    private static final AcceptEncodingHandler s_aInstance = new AcceptEncodingHandler();

    private AcceptEncodingHandler() {
    }

    @Nonnull
    public static AcceptEncodingList getAcceptEncodings(@Nullable String string) {
        AcceptEncodingList acceptEncodingList = new AcceptEncodingList();
        if (StringHelper.hasNoText(string)) {
            acceptEncodingList.addEncoding(IDENTITY_ENCODING, 1.0);
        } else {
            for (String string2 : StringHelper.getExploded(',', string)) {
                String string3;
                String[] stringArray = StringHelper.getExplodedArray(';', string2.trim(), 2);
                String string4 = stringArray[0];
                if (StringHelper.hasNoText(string4)) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("Accept-Encoding item '" + string2 + "' has no encoding!");
                    continue;
                }
                double d = 1.0;
                if (stringArray.length == 2 && (string3 = stringArray[1].trim()).startsWith("q=")) {
                    d = StringParser.parseDouble(string3.substring(2), 1.0);
                }
                acceptEncodingList.addEncoding(string4, d);
            }
        }
        return acceptEncodingList;
    }
}

