/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.codec.IEncoder;
import com.helger.commons.serialize.convert.SerializationConverter;
import com.helger.commons.string.StringHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RFC5987Encoder
implements IEncoder<String, String> {
    public static final char ESCAPE_CHAR = '%';
    private static final byte[] ALLOWED_BYTES = new byte[]{33, 35, 36, 38, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 124, 126};
    private transient Charset m_aCharset;

    public RFC5987Encoder() {
        this(StandardCharsets.UTF_8);
    }

    public RFC5987Encoder(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerializationConverter.writeConvertedObject(this.m_aCharset, objectOutputStream);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aCharset = SerializationConverter.readConvertedObject(objectInputStream, Charset.class);
    }

    @Nonnull
    public static String getRFC5987Encoded(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Src");
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (byte by : string.getBytes(charset)) {
            if (Arrays.binarySearch(ALLOWED_BYTES, by) >= 0) {
                stringBuilder.append((char)by);
                continue;
            }
            stringBuilder.append('%').append(StringHelper.getHexChar(by >> 4 & 0xF)).append(StringHelper.getHexChar(by & 0xF));
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getRFC5987EncodedUTF8(@Nonnull String string) {
        return RFC5987Encoder.getRFC5987Encoded(string, StandardCharsets.UTF_8);
    }

    @Override
    @Nullable
    public String getEncoded(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return RFC5987Encoder.getRFC5987Encoded(string, this.m_aCharset);
    }
}

