/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.csp;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.name.IHasName;
import com.helger.commons.string.StringHelper;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICSPDirective
extends IHasName,
Serializable {
    @Override
    @Nonnull
    @Nonempty
    public String getName();

    @Nullable
    public String getValue();

    default public boolean hasValue() {
        return StringHelper.hasText(this.getValue());
    }

    @Nonnull
    @Nonempty
    default public String getAsString() {
        return StringHelper.getConcatenatedOnDemand(this.getName(), ' ', this.getValue());
    }

    @Nullable
    default public String getAsStringIfHasValue() {
        String string = this.getValue();
        if (StringHelper.hasText(string)) {
            return this.getName() + ' ' + string;
        }
        return null;
    }
}

