/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.tls;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.tls.ETLSVersion;
import com.helger.http.tls.ITLSConfigurationMode;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSConfigurationMode
implements ITLSConfigurationMode {
    private static final Logger LOGGER = LoggerFactory.getLogger(TLSConfigurationMode.class);
    private static final ICommonsMap<ETLSVersion, SSLContext> TLS_CONTEXT_MAP = new CommonsEnumMap<ETLSVersion, SSLContext>(ETLSVersion.class);
    private final ICommonsList<ETLSVersion> m_aTLSVersions;
    private final ICommonsList<String> m_aCipherSuites;

    public static boolean isSupportedCipherSuiteInSSLContext(@Nonnull ETLSVersion[] eTLSVersionArray, @Nonnull @Nonempty String string) {
        for (ETLSVersion eTLSVersion : eTLSVersionArray) {
            SSLParameters sSLParameters;
            CommonsHashSet<String> commonsHashSet;
            SSLContext sSLContext = (SSLContext)TLS_CONTEXT_MAP.get(eTLSVersion);
            if (sSLContext == null || !(commonsHashSet = new CommonsHashSet<String>((sSLParameters = sSLContext.getSupportedSSLParameters()).getCipherSuites())).contains(string)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cipher suite '" + string + "' is supported in TLS version " + eTLSVersion);
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cipher suite '" + string + "' is not supported by any TLS version");
        }
        return false;
    }

    public TLSConfigurationMode(@Nonnull @Nonempty ETLSVersion[] eTLSVersionArray, @Nonnull String[] stringArray) {
        ValueEnforcer.notEmptyNoNullValue(eTLSVersionArray, "TLSVersions");
        ValueEnforcer.notNullNoNullValue(stringArray, "CipherSuites");
        this.m_aTLSVersions = new CommonsArrayList<ETLSVersion>(eTLSVersionArray);
        this.m_aCipherSuites = CommonsArrayList.createFiltered(stringArray, string -> TLSConfigurationMode.isSupportedCipherSuiteInSSLContext(eTLSVersionArray, string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ETLSVersion> getAllTLSVersions() {
        return (ICommonsList)this.m_aTLSVersions.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTLSVersionIDs() {
        return this.m_aTLSVersions.getAllMapped(ETLSVersion::getID);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public String[] getAllTLSVersionIDsAsArray() {
        if (this.m_aTLSVersions.isEmpty()) {
            return null;
        }
        return this.getAllTLSVersionIDs().toArray(new String[this.m_aTLSVersions.size()]);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllCipherSuites() {
        return (ICommonsList)this.m_aCipherSuites.getClone();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public String[] getAllCipherSuitesAsArray() {
        if (this.m_aCipherSuites.isEmpty()) {
            return null;
        }
        return this.m_aCipherSuites.toArray(new String[this.m_aCipherSuites.size()]);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TLSConfigurationMode tLSConfigurationMode = (TLSConfigurationMode)object;
        return this.m_aTLSVersions.equals(tLSConfigurationMode.m_aTLSVersions) && this.m_aCipherSuites.equals(tLSConfigurationMode.m_aCipherSuites);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aTLSVersions)).append(this.m_aCipherSuites)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("TLSVersions", this.m_aTLSVersions).append("CipherSuites", this.m_aCipherSuites).getToString();
    }

    static {
        for (ETLSVersion eTLSVersion : ETLSVersion.values()) {
            try {
                SSLContext sSLContext = SSLContext.getInstance(eTLSVersion.getID());
                sSLContext.init(null, null, null);
                TLS_CONTEXT_MAP.put(eTLSVersion, sSLContext);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (Exception exception) {
                throw new InitializationException("Error creating SSLContext for " + eTLSVersion, exception);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialized TLS ContextMap with " + TLS_CONTEXT_MAP.keySet() + " keys");
        }
    }
}

