/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.http.tls.ITLSConfigurationMode;
import com.helger.httpclient.HttpClientRetryHandler;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;

public interface IHttpClientSettings {
    public boolean isUseSystemProperties();

    public boolean isUseDNSClientCache();

    @Nullable
    public SSLContext getSSLContext();

    @Nullable
    public HostnameVerifier getHostnameVerifier();

    @Nullable
    public ITLSConfigurationMode getTLSConfigurationMode();

    @Nullable
    public HttpHost getProxyHost();

    @Nullable
    public Credentials getProxyCredentials();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsSet<String> nonProxyHosts();

    @Nonnegative
    public int getRetryCount();

    default public boolean hasRetries() {
        return this.getRetryCount() > 0;
    }

    @Nonnull
    public HttpClientRetryHandler.ERetryMode getRetryMode();

    public int getConnectionRequestTimeoutMS();

    public int getConnectionTimeoutMS();

    public int getSocketTimeoutMS();

    @Nullable
    public String getUserAgent();

    default public boolean hasUserAgent() {
        return StringHelper.hasText(this.getUserAgent());
    }

    public boolean isFollowRedirects();
}

