/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.functional.IFunction;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.IJAXBReader;
import com.helger.jaxb.IJAXBWriter;
import com.helger.jaxb.JAXBContextCache;
import com.helger.jaxb.JAXBMarshallerHelper;
import com.helger.jaxb.LoggingJAXBReadExceptionHandler;
import com.helger.jaxb.LoggingJAXBWriteExceptionHandler;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import com.helger.jaxb.validation.IValidationEventHandlerFactory;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.schema.XMLSchemaCache;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class GenericJAXBMarshaller<JAXBTYPE>
implements IHasClassLoader,
IJAXBReader<JAXBTYPE>,
IJAXBWriter<JAXBTYPE> {
    public static final boolean DEFAULT_READ_SECURE = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericJAXBMarshaller.class);
    private final Class<JAXBTYPE> m_aType;
    private final ICommonsList<ClassPathResource> m_aXSDs = new CommonsArrayList<ClassPathResource>();
    private final IFunction<? super JAXBTYPE, ? extends JAXBElement<JAXBTYPE>> m_aJAXBElementWrapper;
    private IValidationEventHandlerFactory m_aVEHFactory;
    private boolean m_bReadSecure = true;
    private boolean m_bFormattedOutput = JAXBBuilderDefaultSettings.isDefaultFormattedOutput();
    private INamespaceContext m_aNSContext = JAXBBuilderDefaultSettings.getDefaultNamespaceContext();
    private Charset m_aCharset = JAXBBuilderDefaultSettings.getDefaultCharset();
    private String m_sIndentString = JAXBBuilderDefaultSettings.getDefaultIndentString();
    private String m_sSchemaLocation = JAXBBuilderDefaultSettings.getDefaultSchemaLocation();
    private String m_sNoNamespaceSchemaLocation = JAXBBuilderDefaultSettings.getDefaultNoNamespaceSchemaLocation();
    private boolean m_bUseContextCache = JAXBBuilderDefaultSettings.isDefaultUseContextCache();
    private WeakReference<ClassLoader> m_aClassLoader;
    private final CallbackList<IExceptionCallback<JAXBException>> m_aReadExceptionCallbacks = new CallbackList();
    private final CallbackList<IExceptionCallback<JAXBException>> m_aWriteExceptionCallbacks = new CallbackList();

    public GenericJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nonnull QName qName) {
        this(clazz, GenericJAXBMarshaller.createSimpleJAXBElement(qName, clazz));
    }

    public GenericJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nonnull IFunction<? super JAXBTYPE, ? extends JAXBElement<JAXBTYPE>> iFunction) {
        this(clazz, null, iFunction);
    }

    public GenericJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nullable List<? extends ClassPathResource> list, @Nonnull IFunction<? super JAXBTYPE, ? extends JAXBElement<JAXBTYPE>> iFunction) {
        this.m_aType = ValueEnforcer.notNull(clazz, "Type");
        if (list != null) {
            ValueEnforcer.notEmptyNoNullValue(list, "XSDs");
            this.m_aXSDs.addAll(list);
        }
        for (ClassPathResource classPathResource : this.m_aXSDs) {
            ValueEnforcer.isTrue(classPathResource.hasClassLoader(), () -> "ClassPathResource " + classPathResource + " should define its ClassLoader for OSGI handling!");
        }
        this.m_aJAXBElementWrapper = ValueEnforcer.notNull(iFunction, "JAXBElementWrapper");
        this.m_aClassLoader = new WeakReference<ClassLoader>(clazz.getClassLoader());
        this.m_aReadExceptionCallbacks.add(new LoggingJAXBReadExceptionHandler());
        this.m_aWriteExceptionCallbacks.add(new LoggingJAXBWriteExceptionHandler());
    }

    @Nonnull
    protected final Class<JAXBTYPE> getType() {
        return this.m_aType;
    }

    @Override
    @Nullable
    public final ClassLoader getClassLoader() {
        return (ClassLoader)this.m_aClassLoader.get();
    }

    public final void setValidationEventHandlerFactory(@Nullable IValidationEventHandlerFactory iValidationEventHandlerFactory) {
        this.m_aVEHFactory = iValidationEventHandlerFactory;
    }

    @Nullable
    public final IValidationEventHandlerFactory getValidationEventHandlerFactory() {
        return this.m_aVEHFactory;
    }

    @Override
    public final boolean isReadSecure() {
        return this.m_bReadSecure;
    }

    @Nonnull
    public final EChange setReadSecure(boolean bl) {
        if (bl == this.m_bReadSecure) {
            return EChange.UNCHANGED;
        }
        this.m_bReadSecure = bl;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public final INamespaceContext getNamespaceContext() {
        return this.m_aNSContext;
    }

    @Nonnull
    public final EChange setNamespaceContext(@Nullable INamespaceContext iNamespaceContext) {
        if (EqualsHelper.equals(iNamespaceContext, this.m_aNSContext)) {
            return EChange.UNCHANGED;
        }
        this.m_aNSContext = iNamespaceContext;
        return EChange.CHANGED;
    }

    @Override
    public final boolean isFormattedOutput() {
        return this.m_bFormattedOutput;
    }

    @Nonnull
    public final EChange setFormattedOutput(boolean bl) {
        if (bl == this.m_bFormattedOutput) {
            return EChange.UNCHANGED;
        }
        this.m_bFormattedOutput = bl;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final EChange setCharset(@Nullable Charset charset) {
        if (EqualsHelper.equals(charset, this.m_aCharset)) {
            return EChange.UNCHANGED;
        }
        this.m_aCharset = charset;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public final String getIndentString() {
        return this.m_sIndentString;
    }

    @Nonnull
    public final EChange setIndentString(@Nullable String string) {
        if (EqualsHelper.equals(string, this.m_sIndentString)) {
            return EChange.UNCHANGED;
        }
        this.m_sIndentString = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public final String getSchemaLocation() {
        return this.m_sSchemaLocation;
    }

    @Nonnull
    public final EChange setSchemaLocation(@Nullable String string) {
        if (EqualsHelper.equals(string, this.m_sSchemaLocation)) {
            return EChange.UNCHANGED;
        }
        this.m_sSchemaLocation = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public final String getNoNamespaceSchemaLocation() {
        return this.m_sNoNamespaceSchemaLocation;
    }

    @Nonnull
    public final EChange setNoNamespaceSchemaLocation(@Nullable String string) {
        if (EqualsHelper.equals(string, this.m_sNoNamespaceSchemaLocation)) {
            return EChange.UNCHANGED;
        }
        this.m_sNoNamespaceSchemaLocation = string;
        return EChange.CHANGED;
    }

    @Nonnull
    public final EChange setUseContextCache(boolean bl) {
        if (bl == this.m_bUseContextCache) {
            return EChange.UNCHANGED;
        }
        this.m_bUseContextCache = bl;
        return EChange.CHANGED;
    }

    public final boolean isUseContextCache() {
        return this.m_bUseContextCache;
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<JAXBException>> readExceptionCallbacks() {
        return this.m_aReadExceptionCallbacks;
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<JAXBException>> writeExceptionCallbacks() {
        return this.m_aWriteExceptionCallbacks;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final ICommonsList<ClassPathResource> getOriginalXSDs() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Nullable
    protected Schema createValidationSchema() {
        return this.m_aXSDs.isEmpty() ? null : XMLSchemaCache.getInstanceOfClassLoader(this.getClassLoader()).getSchema(this.m_aXSDs);
    }

    @Nonnull
    @OverrideOnDemand
    protected JAXBContext getJAXBContext(@Nullable ClassLoader classLoader) throws JAXBException {
        Package package_ = this.m_aType.getPackage();
        if (this.m_bUseContextCache) {
            return JAXBContextCache.getInstance().getFromCache(package_, classLoader);
        }
        return JAXBContext.newInstance(package_.getName(), classLoader);
    }

    @Nonnull
    private Unmarshaller _createUnmarshaller(@Nullable ClassLoader classLoader) throws JAXBException {
        Object object;
        JAXBContext jAXBContext = this.getJAXBContext(classLoader);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        if (this.m_aVEHFactory != null && (object = this.m_aVEHFactory.apply(unmarshaller.getEventHandler())) != null) {
            unmarshaller.setEventHandler((ValidationEventHandler)object);
        }
        if ((object = this.createValidationSchema()) != null) {
            unmarshaller.setSchema((Schema)object);
        }
        return unmarshaller;
    }

    @OverrideOnDemand
    protected void customizeUnmarshaller(@Nonnull Unmarshaller unmarshaller) {
    }

    @Override
    @Nullable
    public final JAXBTYPE read(@Nonnull IJAXBReader.IJAXBUnmarshaller<JAXBTYPE> iJAXBUnmarshaller) {
        ValueEnforcer.notNull(iJAXBUnmarshaller, "Handler");
        try {
            Unmarshaller unmarshaller = this._createUnmarshaller(this.getClassLoader());
            this.customizeUnmarshaller(unmarshaller);
            return iJAXBUnmarshaller.doUnmarshal(unmarshaller, this.m_aType).getValue();
        }
        catch (JAXBException jAXBException) {
            this.m_aReadExceptionCallbacks.forEach((Consumer<IExceptionCallback<JAXBException>>)((Consumer<IExceptionCallback>)iExceptionCallback -> iExceptionCallback.onException(jAXBException)));
            return null;
        }
    }

    @Nonnull
    private Marshaller _createMarshaller(@Nullable ClassLoader classLoader) throws JAXBException {
        Object object;
        JAXBContext jAXBContext = this.getJAXBContext(classLoader);
        Marshaller marshaller = jAXBContext.createMarshaller();
        if (this.m_aVEHFactory != null && (object = this.m_aVEHFactory.apply(marshaller.getEventHandler())) != null) {
            marshaller.setEventHandler((ValidationEventHandler)object);
        }
        if (this.m_aNSContext != null) {
            try {
                JAXBMarshallerHelper.setSunNamespacePrefixMapper(marshaller, this.m_aNSContext);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to set the namespace context " + this.m_aNSContext + ": " + exception.getClass().getName() + " -- " + exception.getMessage(), GlobalDebug.isDebugMode() ? exception.getCause() : null);
            }
        }
        JAXBMarshallerHelper.setFormattedOutput(marshaller, this.m_bFormattedOutput);
        if (this.m_aCharset != null) {
            JAXBMarshallerHelper.setEncoding(marshaller, this.m_aCharset);
        }
        if (this.m_sIndentString != null) {
            JAXBMarshallerHelper.setSunIndentString(marshaller, this.m_sIndentString);
        }
        if (this.m_sSchemaLocation != null) {
            JAXBMarshallerHelper.setSchemaLocation(marshaller, this.m_sSchemaLocation);
        }
        if (this.m_sNoNamespaceSchemaLocation != null) {
            JAXBMarshallerHelper.setNoNamespaceSchemaLocation(marshaller, this.m_sNoNamespaceSchemaLocation);
        }
        if ((object = this.createValidationSchema()) != null) {
            marshaller.setSchema((Schema)object);
        }
        return marshaller;
    }

    @OverrideOnDemand
    protected void customizeMarshaller(@Nonnull Marshaller marshaller) {
    }

    @Override
    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull IJAXBWriter.IJAXBMarshaller<JAXBTYPE> iJAXBMarshaller) {
        ValueEnforcer.notNull(JAXBTYPE, "Object");
        ValueEnforcer.notNull(iJAXBMarshaller, "MarshallerFunc");
        try {
            Marshaller marshaller = this._createMarshaller(this.getClassLoader());
            this.customizeMarshaller(marshaller);
            JAXBElement jAXBElement = (JAXBElement)this.m_aJAXBElementWrapper.apply(JAXBTYPE);
            iJAXBMarshaller.doMarshal(marshaller, jAXBElement);
            return ESuccess.SUCCESS;
        }
        catch (JAXBException jAXBException) {
            this.m_aWriteExceptionCallbacks.forEach((Consumer<IExceptionCallback<JAXBException>>)((Consumer<IExceptionCallback>)iExceptionCallback -> iExceptionCallback.onException(jAXBException)));
            return ESuccess.FAILURE;
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("Type", this.m_aType).append("XSDs", this.m_aXSDs).append("JAXBElementWrapper", this.m_aJAXBElementWrapper).append("VEHFactory", this.m_aVEHFactory).append("ReadSecure", this.m_bReadSecure).append("FormattedOutput", this.m_bFormattedOutput).append("NSContext", this.m_aNSContext).append("Charset", this.m_aCharset).append("IndentString", StringHelper.getHexEncoded(this.m_sIndentString, StandardCharsets.ISO_8859_1)).append("SchemaLocation", this.m_sSchemaLocation).append("NoNamespaceSchemaLocation", this.m_sNoNamespaceSchemaLocation).append("UseContextCache", this.m_bUseContextCache).append("ClassLoader", this.m_aClassLoader).append("ReadExceptionHandlers", this.m_aReadExceptionCallbacks).append("WriteExceptionHandlers", this.m_aWriteExceptionCallbacks).getToString();
    }

    @Nonnull
    public static <T> IFunction<T, JAXBElement<T>> createSimpleJAXBElement(@Nonnull QName qName, @Nonnull Class<T> clazz) {
        return object -> new JAXBElement<Object>(qName, clazz, null, object);
    }
}

