/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.ENewLineMode;
import com.helger.json.serialize.IJsonWriterSettings;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonWriterSettings
implements IJsonWriterSettings {
    public static final boolean DEFAULT_INDENT_ENABLED = false;
    public static final String DEFAULT_INDENT_STRING = "  ";
    public static final String DEFAULT_NEWLINE_STRING = ENewLineMode.DEFAULT.getText();
    public static final boolean DEFAULT_WRITE_NEWLINE_AT_END = false;
    public static final boolean DEFAULT_QUOTE_NAMES = true;
    public static final IJsonWriterSettings DEFAULT_SETTINGS = new JsonWriterSettings();
    private boolean m_bIndentEnabled = false;
    private String m_sIndentString = "  ";
    private String m_sNewlineString = DEFAULT_NEWLINE_STRING;
    private boolean m_bWriteNewlineAtEnd = false;
    private boolean m_bQuoteNames = true;

    public JsonWriterSettings() {
    }

    public JsonWriterSettings(@Nonnull IJsonWriterSettings iJsonWriterSettings) {
        ValueEnforcer.notNull(iJsonWriterSettings, "Other");
        this.setIndentEnabled(iJsonWriterSettings.isIdentEnabled());
        this.setIndentString(iJsonWriterSettings.getIndentString());
        this.setNewlineString(iJsonWriterSettings.getNewlineString());
        this.setWriteNewlineAtEnd(iJsonWriterSettings.isWriteNewlineAtEnd());
        this.setQuoteNames(iJsonWriterSettings.isQuoteNames());
    }

    @Override
    public boolean isIdentEnabled() {
        return this.m_bIndentEnabled;
    }

    @Nonnull
    public final JsonWriterSettings setIndentEnabled(boolean bl) {
        this.m_bIndentEnabled = bl;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getIndentString() {
        return this.m_sIndentString;
    }

    @Nonnull
    public final JsonWriterSettings setIndentString(@Nonnull @Nonempty String string) {
        this.m_sIndentString = ValueEnforcer.notEmpty(string, "IndentString");
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNewlineString() {
        return this.m_sNewlineString;
    }

    @Nonnull
    public final JsonWriterSettings setNewlineString(@Nonnull @Nonempty String string) {
        this.m_sNewlineString = ValueEnforcer.notEmpty(string, "NewlineString");
        return this;
    }

    @Override
    public boolean isWriteNewlineAtEnd() {
        return this.m_bWriteNewlineAtEnd;
    }

    @Nonnull
    public final JsonWriterSettings setWriteNewlineAtEnd(boolean bl) {
        this.m_bWriteNewlineAtEnd = bl;
        return this;
    }

    @Override
    public boolean isQuoteNames() {
        return this.m_bQuoteNames;
    }

    @Nonnull
    public final JsonWriterSettings setQuoteNames(boolean bl) {
        this.m_bQuoteNames = bl;
        return this;
    }

    @Override
    @Nonnull
    public JsonWriterSettings getClone() {
        return new JsonWriterSettings(this);
    }

    public String toString() {
        return new ToStringGenerator(this).append("IndentEnabled", this.m_bIndentEnabled).append("IndentString", StringHelper.getHexEncoded(this.m_sIndentString, StandardCharsets.ISO_8859_1)).append("NewlineString", StringHelper.getHexEncoded(this.m_sNewlineString, StandardCharsets.ISO_8859_1)).append("WriteNewlineAtEnd", this.m_bWriteNewlineAtEnd).append("QuoteNames", this.m_bQuoteNames).getToString();
    }
}

