/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mail.address;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.email.EmailAddress;
import com.helger.commons.email.IEmailAddress;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

@Immutable
public final class InternetAddressHelper {
    private static final InternetAddressHelper s_aInstance = new InternetAddressHelper();

    private InternetAddressHelper() {
    }

    @Nonnull
    public static InternetAddress getAsInternetAddress(@Nonnull IEmailAddress iEmailAddress, @Nullable Charset charset) throws AddressException {
        return InternetAddressHelper.getAsInternetAddress(iEmailAddress.getAddress(), iEmailAddress.getPersonal(), charset);
    }

    @Nonnull
    public static InternetAddress getAsInternetAddress(@Nonnull String string, @Nullable String string2, @Nullable Charset charset) throws AddressException {
        try {
            return InternetAddressHelper.getAsInternetAddress(string, string2, charset == null ? null : charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Charset " + charset + " is unknown!", unsupportedEncodingException);
        }
    }

    @Nonnull
    public static InternetAddress getAsInternetAddress(@Nonnull IEmailAddress iEmailAddress, @Nullable String string) throws UnsupportedEncodingException, AddressException {
        return InternetAddressHelper.getAsInternetAddress(iEmailAddress.getAddress(), iEmailAddress.getPersonal(), string);
    }

    @Nonnull
    public static InternetAddress getAsInternetAddress(@Nonnull String string, @Nullable String string2, @Nullable String string3) throws UnsupportedEncodingException, AddressException {
        InternetAddress internetAddress = new InternetAddress(string, string2, string3);
        internetAddress.validate();
        return internetAddress;
    }

    @Nonnull
    public static InternetAddress[] getAsInternetAddressArray(@Nonnull ICommonsList<? extends IEmailAddress> iCommonsList, @Nullable Charset charset) throws AddressException {
        ValueEnforcer.notNull(iCommonsList, "Addresses");
        InternetAddress[] internetAddressArray = new InternetAddress[iCommonsList.size()];
        int n = 0;
        for (IEmailAddress iEmailAddress : iCommonsList) {
            internetAddressArray[n++] = InternetAddressHelper.getAsInternetAddress(iEmailAddress, charset);
        }
        return internetAddressArray;
    }

    @Nullable
    public static EmailAddress getAsEmailAddress(@Nullable InternetAddress internetAddress) {
        return internetAddress == null ? null : new EmailAddress(internetAddress.getAddress(), internetAddress.getPersonal());
    }
}

