/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mail.datasource;

import com.helger.mail.cte.IContentTransferEncoding;
import com.helger.mail.datasource.IExtendedDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.EncodingAware;

public interface IEncodingAwareDataSource
extends IExtendedDataSource,
EncodingAware {
    @Nullable
    public IContentTransferEncoding getContentTransferEncoding();

    @Override
    @Nullable
    default public String getEncoding() {
        IContentTransferEncoding iContentTransferEncoding = this.getContentTransferEncoding();
        return iContentTransferEncoding == null ? null : (String)iContentTransferEncoding.getID();
    }

    @Nonnull
    public static IEncodingAwareDataSource getEncodingAware(final @Nonnull DataSource dataSource, final @Nullable IContentTransferEncoding iContentTransferEncoding) {
        return new IEncodingAwareDataSource(){

            @Override
            public String getContentType() {
                return dataSource.getContentType();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return dataSource.getInputStream();
            }

            @Override
            public String getName() {
                return dataSource.getName();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return dataSource.getOutputStream();
            }

            @Override
            @Nullable
            public IContentTransferEncoding getContentTransferEncoding() {
                return iContentTransferEncoding;
            }
        };
    }
}

