/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mail.datasource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.ToStringGenerator;
import com.helger.mail.datasource.IExtendedDataSource;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InputStreamProviderDataSource
implements IExtendedDataSource {
    private final transient IHasInputStream m_aISP;
    private int m_nISAcquired = 0;
    private final String m_sName;
    private final String m_sContentType;

    public InputStreamProviderDataSource(@Nonnull IHasInputStream iHasInputStream, @Nonnull String string) {
        this(iHasInputStream, string, (String)null);
    }

    public InputStreamProviderDataSource(@Nonnull IHasInputStream iHasInputStream, @Nonnull String string, @Nullable IMimeType iMimeType) {
        this(iHasInputStream, string, iMimeType == null ? null : iMimeType.getAsString());
    }

    public InputStreamProviderDataSource(@Nonnull IHasInputStream iHasInputStream, @Nonnull String string, @Nullable String string2) {
        this.m_aISP = ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        this.m_sName = ValueEnforcer.notNull(string, "Name");
        this.m_sContentType = string2 != null ? string2 : DEFAULT_CONTENT_TYPE.getAsString();
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        ++this.m_nISAcquired;
        if (!this.m_aISP.isReadMultiple() && this.m_nISAcquired > 1) {
            throw new IllegalStateException("The input stream was already acquired " + (this.m_nISAcquired - 1) + " times!");
        }
        return this.m_aISP.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("Read-only!");
    }

    @Override
    @Nonnull
    public String getContentType() {
        return this.m_sContentType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISP", this.m_aISP).append("ISAcquired", this.m_nISAcquired).append("Name", this.m_sName).append("ContentType", this.m_sContentType).getToString();
    }
}

