/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.address;

import com.helger.masterdata.address.IPostalAddress;
import com.helger.masterdata.address.PostalAddressHelper;
import java.util.Locale;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EPostalAddressField {
    CARE_OF((iPostalAddress, locale) -> iPostalAddress.hasCareOf() ? PostalAddressHelper.getCareOfPrefix() + iPostalAddress.getCareOf() : null),
    STREET((iPostalAddress, locale) -> iPostalAddress.hasStreet() ? iPostalAddress.getStreet() : null),
    BUILDING_NUMBER((iPostalAddress, locale) -> iPostalAddress.hasBuildingNumber() ? iPostalAddress.getBuildingNumber() : null),
    STREET_AND_BUILDING_NUMBER((iPostalAddress, locale) -> PostalAddressHelper.getStreetAndBuildingNumber(iPostalAddress)),
    POSTAL_CODE((iPostalAddress, locale) -> iPostalAddress.hasPostalCode() ? iPostalAddress.getPostalCode() : null),
    CITY((iPostalAddress, locale) -> iPostalAddress.hasCity() ? iPostalAddress.getCity() : null),
    POSTAL_CODE_AND_CITY((iPostalAddress, locale) -> PostalAddressHelper.getPostalCodeAndCity(iPostalAddress)),
    POST_OFFICE_BOX((iPostalAddress, locale) -> iPostalAddress.hasPostOfficeBox() ? iPostalAddress.getPostOfficeBox() : null),
    STATE((iPostalAddress, locale) -> iPostalAddress.hasState() ? iPostalAddress.getState() : null),
    COUNTRY((iPostalAddress, locale) -> iPostalAddress.hasCountry() ? iPostalAddress.getCountryDisplayName((Locale)locale) : null);

    private final BiFunction<IPostalAddress, Locale, String> m_aGetter;

    private EPostalAddressField(BiFunction<IPostalAddress, Locale, String> biFunction) {
        this.m_aGetter = biFunction;
    }

    @Nullable
    public String get(@Nonnull IPostalAddress iPostalAddress, @Nonnull Locale locale) {
        return this.m_aGetter.apply(iPostalAddress, locale);
    }
}

