/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.address;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.address.EPostalAddressField;
import com.helger.masterdata.address.IPostalAddress;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PostalAddressHelper {
    public static final boolean DEFAULT_COMPLEX_ADDRESS_HANDLING_ENABLED = false;
    public static final String DEFAULT_CARE_OF_PREFIX = "c/o ";
    public static final String DEFAULT_LINE_SEPARATOR = "\n";
    private static final String[] STREET_SEARCH = new String[]{"str.", "g."};
    private static final String[] STREET_REPLACE = new String[]{"stra\u00dfe", "gasse"};
    private static final SimpleReadWriteLock s_aRWLock;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bComplexAddressHandlingEnabled;
    @GuardedBy(value="s_aRWLock")
    private static String s_sCareOfPrefix;

    private PostalAddressHelper() {
    }

    public static boolean isComplexAddressHandlingEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bComplexAddressHandlingEnabled);
    }

    public static void setComplexAddressHandlingEnabled(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bComplexAddressHandlingEnabled = bl;
            return s_bComplexAddressHandlingEnabled;
        });
    }

    @Nonnull
    public static String getCareOfPrefix() {
        return s_aRWLock.readLockedGet(() -> s_sCareOfPrefix);
    }

    public static void setCareOfPrefix(@Nonnull String string) {
        ValueEnforcer.notNull(string, "CareOfPrefix");
        s_aRWLock.writeLockedGet(() -> {
            s_sCareOfPrefix = string;
            return s_sCareOfPrefix;
        });
    }

    @Nullable
    private static String _unifyPart(@Nonnull String string, @Nonnull Locale locale) {
        String string2 = string.trim();
        int n = string2.length();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return string2.toUpperCase(locale);
        }
        string2 = string2.substring(0, 1).toUpperCase(locale) + string2.substring(1);
        return string2;
    }

    @Nullable
    public static String getUnifiedStreet(@Nullable String string, @Nonnull Locale locale) {
        if (!PostalAddressHelper.isComplexAddressHandlingEnabled()) {
            return string;
        }
        if (string == null) {
            return null;
        }
        String string2 = StringHelper.replaceMultiple(string, STREET_SEARCH, STREET_REPLACE);
        return PostalAddressHelper._unifyPart(string2, locale);
    }

    @Nullable
    public static String getUnifiedCity(@Nullable String string, @Nonnull Locale locale) {
        if (!PostalAddressHelper.isComplexAddressHandlingEnabled()) {
            return string;
        }
        if (string == null) {
            return null;
        }
        return PostalAddressHelper._unifyPart(string, locale);
    }

    @Nullable
    public static String getUnifiedPOBox(@Nullable String string, @Nonnull Locale locale) {
        if (!PostalAddressHelper.isComplexAddressHandlingEnabled()) {
            return string;
        }
        if (string == null) {
            return null;
        }
        return PostalAddressHelper._unifyPart(string, locale);
    }

    @Nullable
    public static String getUnifiedCareOf(@Nullable String string, @Nonnull Locale locale) {
        if (!PostalAddressHelper.isComplexAddressHandlingEnabled()) {
            return string;
        }
        if (string == null) {
            return null;
        }
        return PostalAddressHelper._unifyPart(string, locale);
    }

    @Nullable
    public static String getUnifiedState(@Nullable String string, @Nonnull Locale locale) {
        if (!PostalAddressHelper.isComplexAddressHandlingEnabled()) {
            return string;
        }
        if (string == null) {
            return null;
        }
        return PostalAddressHelper._unifyPart(string, locale);
    }

    @Nullable
    public static String getUnifiedCountry(@Nullable String string, @Nonnull Locale locale) {
        if (!PostalAddressHelper.isComplexAddressHandlingEnabled()) {
            return string;
        }
        if (string == null) {
            return null;
        }
        return PostalAddressHelper._unifyPart(string, locale);
    }

    @Nullable
    public static String getStreetAndBuildingNumber(@Nullable IPostalAddress iPostalAddress) {
        if (iPostalAddress == null) {
            return null;
        }
        return StringHelper.getImplodedNonEmpty(' ', iPostalAddress.getStreet(), iPostalAddress.getBuildingNumber());
    }

    @Nullable
    public static String getPostalCodeAndCity(@Nullable IPostalAddress iPostalAddress) {
        if (iPostalAddress == null) {
            return null;
        }
        return StringHelper.getImplodedNonEmpty(' ', iPostalAddress.getPostalCode(), iPostalAddress.getCity());
    }

    @Nullable
    public static String getAddressString(@Nullable IPostalAddress iPostalAddress, @Nonnull Locale locale) {
        return PostalAddressHelper.getAddressString(iPostalAddress, locale, DEFAULT_LINE_SEPARATOR);
    }

    @Nullable
    public static String getAddressString(@Nullable IPostalAddress iPostalAddress, @Nonnull Locale locale, @Nonnull String string) {
        return PostalAddressHelper.getAddressString(iPostalAddress, new CommonsArrayList<EPostalAddressField>(EPostalAddressField.CARE_OF, EPostalAddressField.STREET_AND_BUILDING_NUMBER, EPostalAddressField.POSTAL_CODE_AND_CITY, EPostalAddressField.POST_OFFICE_BOX, EPostalAddressField.COUNTRY), locale, string);
    }

    @Nullable
    public static String getAddressString(@Nullable IPostalAddress iPostalAddress, @Nonnull List<EPostalAddressField> list, @Nonnull Locale locale) {
        return PostalAddressHelper.getAddressString(iPostalAddress, list, locale, DEFAULT_LINE_SEPARATOR);
    }

    @Nullable
    public static String getAddressString(@Nullable IPostalAddress iPostalAddress, @Nonnull List<EPostalAddressField> list, @Nonnull Locale locale, @Nonnull String string) {
        ValueEnforcer.notNull(list, "Fields");
        ValueEnforcer.notNull(locale, "DisplayLocale");
        ValueEnforcer.notNull(string, "LineSeparator");
        if (iPostalAddress == null) {
            return null;
        }
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(list.size());
        for (EPostalAddressField ePostalAddressField : list) {
            commonsArrayList.add(ePostalAddressField.get(iPostalAddress, locale));
        }
        return StringHelper.getImplodedNonEmpty(string, commonsArrayList);
    }

    static {
        if (STREET_SEARCH.length != STREET_REPLACE.length) {
            throw new InitializationException("Search and replace arrays for street have different length!");
        }
        s_aRWLock = new SimpleReadWriteLock();
        s_bComplexAddressHandlingEnabled = false;
        s_sCareOfPrefix = DEFAULT_CARE_OF_PREFIX;
    }
}

