/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.address;

import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemHelper;
import com.helger.masterdata.address.EPostalAddressType;
import com.helger.masterdata.address.PostalAddress;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PostalAddressMicroTypeConverter
implements IMicroTypeConverter<PostalAddress> {
    private static final IMicroQName ATTR_TYPE = new MicroQName("type");
    private static final IMicroQName ATTR_COUNTRY = new MicroQName("country");
    private static final IMicroQName ATTR_STATE = new MicroQName("state");
    private static final IMicroQName ATTR_POSTALCODE = new MicroQName("zipcode");
    private static final IMicroQName ATTR_CITY = new MicroQName("city");
    private static final IMicroQName ATTR_STREET = new MicroQName("street");
    private static final IMicroQName ATTR_BUILDINGNUMBER = new MicroQName("buildingno");
    private static final IMicroQName ATTR_POBOX = new MicroQName("pobox");
    private static final IMicroQName ATTR_CARE_OF = new MicroQName("careof");

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull PostalAddress postalAddress, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        if (postalAddress.getType() != null) {
            microElement.setAttribute(ATTR_TYPE, (String)postalAddress.getType().getID());
        }
        if (StringHelper.hasText(postalAddress.getCountry())) {
            microElement.setAttribute(ATTR_COUNTRY, postalAddress.getCountry());
        }
        if (StringHelper.hasText(postalAddress.getState())) {
            microElement.setAttribute(ATTR_STATE, postalAddress.getState());
        }
        if (StringHelper.hasText(postalAddress.getPostalCode())) {
            microElement.setAttribute(ATTR_POSTALCODE, postalAddress.getPostalCode());
        }
        if (StringHelper.hasText(postalAddress.getCity())) {
            microElement.setAttribute(ATTR_CITY, postalAddress.getCity());
        }
        if (StringHelper.hasText(postalAddress.getStreet())) {
            microElement.setAttribute(ATTR_STREET, postalAddress.getStreet());
        }
        if (StringHelper.hasText(postalAddress.getBuildingNumber())) {
            microElement.setAttribute(ATTR_BUILDINGNUMBER, postalAddress.getBuildingNumber());
        }
        if (StringHelper.hasText(postalAddress.getPostOfficeBox())) {
            microElement.setAttribute(ATTR_POBOX, postalAddress.getPostOfficeBox());
        }
        if (StringHelper.hasText(postalAddress.getCareOf())) {
            microElement.setAttribute(ATTR_CARE_OF, postalAddress.getCareOf());
        }
        return microElement;
    }

    @Override
    @Nonnull
    public PostalAddress convertToNative(@Nonnull IMicroElement iMicroElement) {
        Locale locale = SystemHelper.getSystemLocale();
        EPostalAddressType ePostalAddressType = EPostalAddressType.getFromIDOrNull(iMicroElement.getAttributeValue(ATTR_TYPE));
        String string = iMicroElement.getAttributeValue(ATTR_COUNTRY);
        String string2 = iMicroElement.getAttributeValue(ATTR_STATE);
        String string3 = iMicroElement.getAttributeValue(ATTR_POSTALCODE);
        String string4 = iMicroElement.getAttributeValue(ATTR_CITY);
        String string5 = iMicroElement.getAttributeValue(ATTR_STREET);
        String string6 = iMicroElement.getAttributeValue(ATTR_BUILDINGNUMBER);
        String string7 = iMicroElement.getAttributeValue(ATTR_POBOX);
        String string8 = iMicroElement.getAttributeValue(ATTR_CARE_OF);
        return new PostalAddress(ePostalAddressType, string, string2, string3, string4, string5, string6, string7, string8, locale);
    }
}

