/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.ean;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.EValidity;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.ean.AbstractUPCEAN;
import com.helger.masterdata.ean.EEANChecksumMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class EAN8
extends AbstractUPCEAN {
    public EAN8(@Nonnull String string) {
        this(string, DEFAULT_CHECKSUM_MODE);
    }

    public EAN8(@Nonnull String string, @Nonnull EEANChecksumMode eEANChecksumMode) {
        super(string, eEANChecksumMode);
    }

    @Override
    @Nonnull
    public EValidity validate() {
        return EAN8.validateMessage(this.getMessage());
    }

    @Nonnull
    public static EValidity validateMessage(@Nullable String string) {
        int n = StringHelper.getLength(string);
        if (n >= 7 && n <= 8 && AbstractUPCEAN.validateMessage(string).isValid()) {
            return EValidity.VALID;
        }
        return EValidity.INVALID;
    }

    @Nonnull
    public String getWithCorrectChecksum() {
        return EAN8.getWithCorrectChecksum(this.getMessage(), this.getChecksumMode());
    }

    @Nonnull
    public static String getWithCorrectChecksum(@Nonnull String string, @Nonnull EEANChecksumMode eEANChecksumMode) {
        ValueEnforcer.notNull(string, "Msg");
        ValueEnforcer.notNull(eEANChecksumMode, "ChecksumMode");
        EEANChecksumMode eEANChecksumMode2 = eEANChecksumMode;
        if (eEANChecksumMode2 == EEANChecksumMode.AUTO) {
            if (string.length() == 7) {
                eEANChecksumMode2 = EEANChecksumMode.ADD;
            } else if (string.length() == 8) {
                eEANChecksumMode2 = EEANChecksumMode.CHECK;
            } else {
                throw new IllegalArgumentException("Failed to automatically detect the checksum mode");
            }
        }
        switch (eEANChecksumMode2) {
            case ADD: {
                if (string.length() != 7) {
                    throw new IllegalArgumentException("Message must be 7 characters long");
                }
                return string + EAN8.calcChecksumChar(string, 7);
            }
            case CHECK: {
                char c;
                if (string.length() != 8) {
                    throw new IllegalArgumentException("Message must be 8 characters long");
                }
                char c2 = string.charAt(7);
                if (c2 != (c = EAN8.calcChecksumChar(string, 7))) {
                    throw new IllegalArgumentException("Checksum is bad (" + c2 + "). Expected: " + c);
                }
                return string;
            }
            case IGNORE: {
                return string;
            }
        }
        throw new IllegalArgumentException("Unknown checksum mode: " + eEANChecksumMode2);
    }
}

