/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.email;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.masterdata.email.IEmailAddressType;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmailAddressType
implements IEmailAddressType {
    private final String m_sID;
    private final IHasDisplayText m_aText;

    public EmailAddressType(@Nonnull @Nonempty String string, @Nonnull IHasDisplayText iHasDisplayText) {
        ValueEnforcer.notEmpty(string, "ID");
        ValueEnforcer.notNull(iHasDisplayText, "Text");
        this.m_sID = string;
        this.m_aText = iHasDisplayText;
    }

    @Override
    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aText.getDisplayText(locale);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailAddressType emailAddressType = (EmailAddressType)object;
        return this.m_sID.equals(emailAddressType.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("Text", this.m_aText).getToString();
    }
}

