/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.exchangeratio;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class ExchangeRatio
implements Serializable {
    private final LocalDate m_aDate;
    private final BigDecimal m_aRatio;

    public ExchangeRatio(@Nonnull LocalDate localDate, @Nonnull @Nonnegative BigDecimal bigDecimal) {
        this.m_aDate = ValueEnforcer.notNull(localDate, "Date");
        this.m_aRatio = ValueEnforcer.isGT0(bigDecimal, "Ratio");
    }

    @Nonnull
    public LocalDate getDate() {
        return this.m_aDate;
    }

    @Nonnegative
    @Nonnull
    public BigDecimal getRatio() {
        return this.m_aRatio;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ExchangeRatio exchangeRatio = (ExchangeRatio)object;
        return this.m_aDate.equals(exchangeRatio.m_aDate) && EqualsHelper.equals(this.m_aRatio, exchangeRatio.m_aRatio);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aDate).append(this.m_aRatio).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("date", this.m_aDate).append("ratio", this.m_aRatio).getToString();
    }
}

