/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.exchangeratio;

import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.exchangeratio.ExchangeRatio;
import com.helger.masterdata.exchangeratio.ExchangeRatioList;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExchangeRatioListMicroTypeConverter
implements IMicroTypeConverter<ExchangeRatioList> {
    private static final IMicroQName ATTR_CURRENCY = new MicroQName("currency");
    private static final String ELEMENT_EXCHANGE_RATIO = "exchangeratio";

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull ExchangeRatioList exchangeRatioList, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_CURRENCY, exchangeRatioList.getCurrencyID());
        for (ExchangeRatio exchangeRatio : exchangeRatioList.getAllExchangeRatios()) {
            microElement.appendChild(MicroTypeConverter.convertToMicroElement(exchangeRatio, string, ELEMENT_EXCHANGE_RATIO));
        }
        return microElement;
    }

    @Override
    @Nonnull
    public ExchangeRatioList convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_CURRENCY);
        ECurrency eCurrency = ECurrency.getFromIDOrNull(string);
        if (eCurrency == null) {
            throw new IllegalStateException("Failed to resolve currency with ID '" + string + "'");
        }
        ExchangeRatioList exchangeRatioList = new ExchangeRatioList(eCurrency);
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_EXCHANGE_RATIO)) {
            exchangeRatioList.addExchangeRatio(MicroTypeConverter.convertToNative(iMicroElement2, ExchangeRatio.class));
        }
        return exchangeRatioList;
    }
}

