/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.isbn;

import com.helger.commons.regex.RegExHelper;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ISBN {
    private ISBN() {
    }

    public static boolean isValidISBN10Number(@Nullable String string) {
        char c;
        if (string == null || string.length() != 10) {
            return false;
        }
        if (!RegExHelper.stringMatchesPattern("^[0-9]+[0-9X]?$", string)) {
            return false;
        }
        int n = 0;
        for (c = '\u0000'; c < '\t'; ++c) {
            int n2 = Character.digit(string.charAt(c), 10);
            n += n2 * (10 - c) % 11;
        }
        c = (n = 11 - n % 11) == 10 ? (char)'X' : (char)Character.forDigit(n, 10);
        return c == string.charAt(9);
    }

    public static boolean isValidISBN13Number(@Nullable String string) {
        if (string == null || string.length() != 13) {
            return false;
        }
        if (!RegExHelper.stringMatchesPattern("^[0-9]+$", string)) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < 12; ++i) {
            int n2 = Character.digit(string.charAt(i), 10);
            int n3 = 1 + i % 2 * 2;
            n += n2 * n3 % 10;
        }
        return Character.forDigit(n = (10 - n % 10) % 10, 10) == string.charAt(12);
    }

    public static boolean isValidISBNNumber(@Nullable String string) {
        return ISBN.isValidISBN10Number(string) || ISBN.isValidISBN13Number(string);
    }
}

