/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.locale;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsNavigableSet;
import com.helger.commons.functional.IPredicate;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.masterdata.locale.ContinentHelper;
import com.helger.masterdata.locale.EContinentName;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EContinent implements IHasID<String>,
IHasDisplayText
{
    AFRICA("af", EContinentName.AFRICA),
    ANTARCTICA("an", EContinentName.ANTARCTICA),
    ASIA("as", EContinentName.ASIA),
    EUROPE("eu", EContinentName.EUROPE),
    NORTH_AMERICA("na", EContinentName.NORTH_AMERICA),
    OCEANIA("oc", EContinentName.OCEANIA),
    SOUTH_AMERICA("sa", EContinentName.SOUTH_AMERICA),
    UNDEFINED("ud", EContinentName.UNDEFINED);

    private final String m_sID;
    private final EContinentName m_aName;

    private EContinent(String string2, EContinentName eContinentName) {
        this.m_sID = string2;
        this.m_aName = eContinentName;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aName.getDisplayText(locale);
    }

    @Nullable
    public static EContinent getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EContinent.class, string);
    }

    @Nonnull
    public static IPredicate<Locale> filterLocaleCountryOnContinent(@Nonnull EContinent eContinent) {
        ValueEnforcer.notNull(eContinent, "Continent");
        return locale -> CollectionHelper.contains(ContinentHelper.getContinentsOfCountry(locale), eContinent);
    }

    @Nonnull
    public static IPredicate<Locale> filterLocaleCountryOnAnyContinent(EContinent ... eContinentArray) {
        ValueEnforcer.notEmptyNoNullValue(eContinentArray, "Continents");
        return locale -> {
            ICommonsNavigableSet<EContinent> iCommonsNavigableSet = ContinentHelper.getContinentsOfCountry(locale);
            if (iCommonsNavigableSet == null) {
                return false;
            }
            iCommonsNavigableSet.retainAll(new CommonsArrayList<EContinent>(eContinentArray));
            return !iCommonsNavigableSet.isEmpty();
        };
    }
}

