/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.locale;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.locale.country.CountryCache;
import java.time.LocalDate;
import java.time.Month;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EEUCountry implements IHasID<String>
{
    BELGIUM("BE", LocalDate.of(1952, Month.JANUARY, 1)),
    BULGARIA("BG", LocalDate.of(2007, Month.JANUARY, 1)),
    DENMARK("DK", LocalDate.of(1973, Month.JANUARY, 1)),
    GERMANY("DE", LocalDate.of(1952, Month.JANUARY, 1)),
    ESTONIA("EE", LocalDate.of(2004, Month.JANUARY, 1)),
    FINLAND("FI", LocalDate.of(1995, Month.JANUARY, 1)),
    FRANCE("FR", LocalDate.of(1952, Month.JANUARY, 1)),
    GREECE("GR", LocalDate.of(1981, Month.JANUARY, 1)),
    IRELAND("IE", LocalDate.of(1973, Month.JANUARY, 1)),
    ITALY("IT", LocalDate.of(1952, Month.JANUARY, 1)),
    CROATIA("HR", LocalDate.of(2013, Month.JANUARY, 1)),
    LATVIA("LV", LocalDate.of(2004, Month.JANUARY, 1)),
    LITHUANIA("LT", LocalDate.of(2004, Month.JANUARY, 1)),
    LUXEMBOURG("LU", LocalDate.of(1952, Month.JANUARY, 1)),
    MALTA("MT", LocalDate.of(2004, Month.JANUARY, 1)),
    NETHERLANDS("NL", LocalDate.of(1952, Month.JANUARY, 1)),
    AUSTRIA("AT", LocalDate.of(1995, Month.JANUARY, 1)),
    POLAND("PL", LocalDate.of(2004, Month.JANUARY, 1)),
    PORTUGAL("PT", LocalDate.of(1986, Month.JANUARY, 1)),
    ROMANIA("RO", LocalDate.of(2007, Month.JANUARY, 1)),
    SWEDEN("SE", LocalDate.of(1995, Month.JANUARY, 1)),
    SLOVAKIA("SK", LocalDate.of(2004, Month.JANUARY, 1)),
    SLOVENIA("SI", LocalDate.of(2004, Month.JANUARY, 1)),
    SPAIN("ES", LocalDate.of(1986, Month.JANUARY, 1)),
    CZECH_REPUBLIC("CZ", LocalDate.of(2004, Month.JANUARY, 1)),
    HUNGARY("HU", LocalDate.of(2004, Month.JANUARY, 1)),
    UNITED_KINGDOM("GB", LocalDate.of(1973, Month.JANUARY, 1)),
    CYPRUS("CY", LocalDate.of(2004, Month.JANUARY, 1));

    private final String m_sCountryCode;
    private final Locale m_aCountry;
    private final LocalDate m_aJoinDate;

    private EEUCountry(String string2, LocalDate localDate) {
        this.m_sCountryCode = string2;
        this.m_aCountry = CountryCache.getInstance().getCountry(string2);
        if (this.m_aCountry == null) {
            throw new IllegalStateException("Failed to resolve country '" + string2 + "'");
        }
        this.m_aJoinDate = localDate;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sCountryCode;
    }

    @Nonnull
    @Nonempty
    public String getCountryCode() {
        return this.m_sCountryCode;
    }

    @Nonnull
    public Locale getCountry() {
        return this.m_aCountry;
    }

    @Nonnull
    public LocalDate getJoinDate() {
        return this.m_aJoinDate;
    }

    @Nonnegative
    public int getJoinYear() {
        return this.m_aJoinDate.getYear();
    }

    @Nullable
    public static EEUCountry getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EEUCountry.class, string);
    }

    @Nullable
    public static EEUCountry getFromLocaleOrNull(@Nullable Locale locale) {
        return locale == null ? null : EEUCountry.getFromIDOrNull(locale.getCountry());
    }

    public static boolean isEUCountry(@Nullable Locale locale) {
        return EEUCountry.getFromLocaleOrNull(locale) != null;
    }
}

