/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.locale;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ISO639_2Item
implements Serializable {
    private final String m_sAlpha3B;
    private final String m_sAlpha3T;
    private final String m_sAlpha2;
    private final String m_sEN;
    private final String m_sFR;

    public ISO639_2Item(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5) {
        ValueEnforcer.isTrue(StringHelper.getLength(string) == 3, "Alpha3-bibliographic code must be present and have length 3: '" + string + "' - length " + StringHelper.getLength(string));
        if (string2 != null) {
            ValueEnforcer.isEqual(string2.length(), 3, "Alpha3-terminologic code length");
        }
        if (string3 != null) {
            ValueEnforcer.isEqual(string3.length(), 2, "Alpha2 code length");
        }
        ValueEnforcer.notEmpty(string4, "English name");
        ValueEnforcer.notEmpty(string5, "French name");
        this.m_sAlpha3B = string;
        this.m_sAlpha3T = string2;
        this.m_sAlpha2 = string3;
        this.m_sEN = string4;
        this.m_sFR = string5;
    }

    @Nonnull
    @Nonempty
    public String getAlpha3Bibliographic() {
        return this.m_sAlpha3B;
    }

    @Nullable
    public String getAlpha3Terminologic() {
        return this.m_sAlpha3T;
    }

    @Nullable
    public String getAlpha2() {
        return this.m_sAlpha2;
    }

    @Nonnull
    @Nonempty
    public String getEnglishName() {
        return this.m_sEN;
    }

    @Nonnull
    @Nonempty
    public String getFrenchName() {
        return this.m_sFR;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ISO639_2Item iSO639_2Item = (ISO639_2Item)object;
        return this.m_sAlpha3B.equals(iSO639_2Item.m_sAlpha3B) && EqualsHelper.equals(this.m_sAlpha3T, iSO639_2Item.m_sAlpha3T) && EqualsHelper.equals(this.m_sAlpha2, iSO639_2Item.m_sAlpha2) && this.m_sEN.equals(iSO639_2Item.m_sEN) && this.m_sFR.equals(iSO639_2Item.m_sFR);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sAlpha3B).append(this.m_sAlpha3T).append(this.m_sAlpha2).append(this.m_sEN).append(this.m_sFR).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("alpha3b", this.m_sAlpha3B).append("alpha3t", this.m_sAlpha3T).append("alpha2", this.m_sAlpha2).append("English", this.m_sEN).append("French", this.m_sFR).getToString();
    }
}

