/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.masterdata.person.EGender;
import com.helger.masterdata.person.ESalutationGreeting;
import com.helger.masterdata.person.ESalutationGreetingComplete;
import com.helger.masterdata.person.ESalutationName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
public enum ESalutation implements IHasDisplayText,
IHasID<String>
{
    MISTER("mr", EGender.MALE, ESalutationName.MISTER, ESalutationGreeting.MISTER, ESalutationGreetingComplete.MISTER),
    MISSES("mrs", EGender.FEMALE, ESalutationName.MISSES, ESalutationGreeting.MISSES, ESalutationGreetingComplete.MISSES),
    FAMILY("fam", null, ESalutationName.FAMILY, ESalutationGreeting.FAMILY, ESalutationGreetingComplete.FAMILY),
    COMPANY("com", null, ESalutationName.COMPANY, ESalutationGreeting.COMPANY, ESalutationGreetingComplete.COMPANY),
    CLUB("cl", null, ESalutationName.CLUB, ESalutationGreeting.CLUB, ESalutationGreetingComplete.CLUB);

    private final String m_sID;
    private final EGender m_eGender;
    private final IHasDisplayText m_aName;
    private final IHasDisplayText m_aGreeting;
    private final IHasDisplayText m_aGreetingComplete;

    private ESalutation(@Nonnull String string2, @Nonnull EGender eGender, @Nonnull ESalutationName eSalutationName, ESalutationGreeting eSalutationGreeting, ESalutationGreetingComplete eSalutationGreetingComplete) {
        this.m_sID = string2;
        this.m_eGender = eGender;
        this.m_aName = eSalutationName;
        this.m_aGreeting = eSalutationGreeting;
        this.m_aGreetingComplete = eSalutationGreetingComplete;
    }

    @Override
    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public EGender getGender() {
        return this.m_eGender;
    }

    public boolean hasGender() {
        return this.m_eGender != null;
    }

    @Nonnull
    public IHasDisplayText getName() {
        return this.m_aName;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aName.getDisplayText(locale);
    }

    @Nonnull
    public IHasDisplayText getGreeting() {
        return this.m_aGreeting;
    }

    @Nullable
    public String getGreeting(Locale locale) {
        return this.m_aGreeting.getDisplayText(locale);
    }

    @Nullable
    public String getGreetingComplete(Locale locale) {
        return this.m_aGreetingComplete.getDisplayText(locale);
    }

    @Nullable
    public static ESalutation getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(ESalutation.class, string);
    }

    @Nullable
    public static ESalutation getFromIDOrDefault(@Nullable String string, @Nullable ESalutation eSalutation) {
        return EnumHelper.getFromIDOrDefault(ESalutation.class, string, eSalutation);
    }

    @Nullable
    public static ESalutation getFromDisplayNameOrNull(@Nullable String string, @Nonnull Locale locale) {
        return ESalutation.getFromDisplayNameOrDefault(string, locale, null);
    }

    @Nullable
    public static ESalutation getFromDisplayNameOrDefault(@Nullable String string, @Nonnull Locale locale, @Nullable ESalutation eSalutation) {
        if (string != null) {
            for (ESalutation eSalutation2 : ESalutation.values()) {
                String string2 = eSalutation2.getDisplayText(locale);
                if (!string2.equals(string)) continue;
                return eSalutation2;
            }
        }
        return eSalutation;
    }
}

