/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.person.ESalutation;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IPersonName
extends ICloneable<IPersonName>,
Serializable {
    @Nullable
    public ESalutation getSalutation();

    default public boolean hasSaluation() {
        return this.getSalutation() != null;
    }

    @Nullable
    default public String getSalutationID() {
        ESalutation eSalutation = this.getSalutation();
        return eSalutation == null ? null : eSalutation.getID();
    }

    @Nullable
    default public String getSalutationDisplayName(@Nonnull Locale locale) {
        ESalutation eSalutation = this.getSalutation();
        return eSalutation == null ? null : eSalutation.getDisplayText(locale);
    }

    @Nullable
    default public String getGreeting(@Nonnull Locale locale) {
        ESalutation eSalutation = this.getSalutation();
        return eSalutation == null ? null : eSalutation.getGreeting(locale);
    }

    @Nullable
    default public String getGreetingComplete(@Nonnull Locale locale) {
        ESalutation eSalutation = this.getSalutation();
        return eSalutation == null ? null : eSalutation.getGreetingComplete(locale);
    }

    @Nullable
    public String getPrefixTitle();

    default public boolean hasPrefixTitle() {
        return StringHelper.hasText(this.getPrefixTitle());
    }

    @Nullable
    public String getFirstName();

    default public boolean hasFirstName() {
        return StringHelper.hasText(this.getFirstName());
    }

    @Nullable
    public String getMiddleName();

    default public boolean hasMiddleName() {
        return StringHelper.hasText(this.getMiddleName());
    }

    @Nullable
    public String getLastName();

    default public boolean hasLastName() {
        return StringHelper.hasText(this.getLastName());
    }

    @Nullable
    public String getSuffixTitle();

    default public boolean hasSuffixTitle() {
        return StringHelper.hasText(this.getSuffixTitle());
    }
}

