/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.address.IPostalAddress;
import com.helger.masterdata.email.IExtendedEmailAddress;
import com.helger.masterdata.person.EGender;
import com.helger.masterdata.person.IPerson;
import com.helger.masterdata.person.IPersonName;
import com.helger.masterdata.person.PersonAddress;
import com.helger.masterdata.person.PersonEmailAddress;
import com.helger.masterdata.person.PersonName;
import com.helger.masterdata.person.PersonTelephoneNumber;
import com.helger.masterdata.telephone.ITelephoneNumber;
import java.time.LocalDate;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Person
implements IPerson {
    public static final String FIELD_GENDER = "gender";
    public static final int LENGTH_GENDER = 2;
    public static final String FIELD_BIRTHDAY = "birthday";
    private EGender m_eGender;
    private PersonName m_aName;
    private LocalDate m_aBirthday;
    private PersonTelephoneNumber m_aTelephoneNumber;
    private PersonEmailAddress m_aEmailAddress;
    private PersonAddress m_aAddress;

    public Person() {
        this.m_aName = new PersonName();
    }

    public Person(@Nonnull IPerson iPerson, @Nonnull Locale locale) {
        ValueEnforcer.notNull(iPerson, "Base");
        this.setGender(iPerson.getGender());
        this.setName(new PersonName(iPerson.getName(), locale));
        this.setBirthday(iPerson.getBirthday());
        this.setTelephoneNumber(iPerson.getTelephoneNumber());
        this.setEmailAddress(iPerson.getEmailAddress());
        this.setAddress(iPerson.getAddress(), locale);
    }

    public Person(@Nullable EGender eGender, @Nonnull IPersonName iPersonName, @Nullable LocalDate localDate, @Nullable ITelephoneNumber iTelephoneNumber, @Nullable IExtendedEmailAddress iExtendedEmailAddress, @Nullable IPostalAddress iPostalAddress, @Nonnull Locale locale) {
        this.setGender(eGender);
        this.setName(new PersonName(iPersonName, locale));
        this.setBirthday(localDate);
        this.setTelephoneNumber(iTelephoneNumber);
        this.setEmailAddress(iExtendedEmailAddress);
        this.setAddress(iPostalAddress, locale);
    }

    @Override
    @Nullable
    public EGender getGender() {
        return this.m_eGender;
    }

    @Nonnull
    public EChange setGender(@Nullable EGender eGender) {
        if (EqualsHelper.equals(this.m_eGender, eGender)) {
            return EChange.UNCHANGED;
        }
        this.m_eGender = eGender;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public PersonName getName() {
        return this.m_aName;
    }

    @Nonnull
    public EChange setName(@Nonnull PersonName personName) {
        ValueEnforcer.notNull(personName, "Name");
        if (personName.equals(this.m_aName)) {
            return EChange.UNCHANGED;
        }
        this.m_aName = personName;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public LocalDate getBirthday() {
        return this.m_aBirthday;
    }

    @Nonnull
    public EChange setBirthday(@Nullable LocalDate localDate) {
        if (EqualsHelper.equals(this.m_aBirthday, localDate)) {
            return EChange.UNCHANGED;
        }
        this.m_aBirthday = localDate;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public PersonTelephoneNumber getTelephoneNumber() {
        return this.m_aTelephoneNumber;
    }

    @Nonnull
    public EChange setTelephoneNumber(@Nullable PersonTelephoneNumber personTelephoneNumber) {
        if (EqualsHelper.equals(this.m_aTelephoneNumber, personTelephoneNumber)) {
            return EChange.UNCHANGED;
        }
        this.m_aTelephoneNumber = personTelephoneNumber;
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange setTelephoneNumber(@Nullable ITelephoneNumber iTelephoneNumber) {
        PersonTelephoneNumber personTelephoneNumber = null;
        if (iTelephoneNumber != null) {
            personTelephoneNumber = new PersonTelephoneNumber(this, iTelephoneNumber);
        }
        return this.setTelephoneNumber(personTelephoneNumber);
    }

    @Override
    @Nullable
    public PersonEmailAddress getEmailAddress() {
        return this.m_aEmailAddress;
    }

    @Nonnull
    public EChange setEmailAddress(@Nullable PersonEmailAddress personEmailAddress) {
        if (EqualsHelper.equals(this.m_aEmailAddress, personEmailAddress)) {
            return EChange.UNCHANGED;
        }
        this.m_aEmailAddress = personEmailAddress;
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange setEmailAddress(@Nullable IExtendedEmailAddress iExtendedEmailAddress) {
        PersonEmailAddress personEmailAddress = null;
        if (iExtendedEmailAddress != null) {
            personEmailAddress = new PersonEmailAddress(this, iExtendedEmailAddress);
        }
        return this.setEmailAddress(personEmailAddress);
    }

    @Override
    @Nullable
    public PersonAddress getAddress() {
        return this.m_aAddress;
    }

    @Nonnull
    public EChange setAddress(@Nullable PersonAddress personAddress) {
        if (EqualsHelper.equals(this.m_aAddress, personAddress)) {
            return EChange.UNCHANGED;
        }
        this.m_aAddress = personAddress;
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange setAddress(@Nullable IPostalAddress iPostalAddress, @Nonnull Locale locale) {
        PersonAddress personAddress = null;
        if (iPostalAddress != null) {
            personAddress = new PersonAddress(this, iPostalAddress, locale);
        }
        return this.setAddress(personAddress);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Person person = (Person)object;
        return EqualsHelper.equals(this.m_eGender, person.m_eGender) && EqualsHelper.equals(this.m_aName, person.m_aName) && EqualsHelper.equals(this.m_aBirthday, person.m_aBirthday) && EqualsHelper.equals(this.m_aTelephoneNumber, person.m_aTelephoneNumber) && EqualsHelper.equals(this.m_aEmailAddress, person.m_aEmailAddress) && EqualsHelper.equals(this.m_aAddress, person.m_aAddress);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eGender)).append(this.m_aName).append(this.m_aBirthday).append(this.m_aTelephoneNumber).append(this.m_aEmailAddress).append(this.m_aAddress).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull(FIELD_GENDER, this.m_eGender).appendIfNotNull("name", this.m_aName).appendIfNotNull(FIELD_BIRTHDAY, this.m_aBirthday).appendIfNotNull("telephone", this.m_aTelephoneNumber).appendIfNotNull("email", this.m_aEmailAddress).appendIfNotNull("address", this.m_aAddress).getToString();
    }
}

