/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.email.ExtendedEmailAddress;
import com.helger.masterdata.email.IEmailAddressType;
import com.helger.masterdata.email.IExtendedEmailAddress;
import com.helger.masterdata.person.Person;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PersonEmailAddress
extends ExtendedEmailAddress {
    private Person m_aOwner;

    public PersonEmailAddress() {
    }

    public PersonEmailAddress(@Nonnull Person person) {
        this.setOwner(person);
    }

    public PersonEmailAddress(@Nonnull Person person, @Nonnull IExtendedEmailAddress iExtendedEmailAddress) {
        super(iExtendedEmailAddress);
        this.setOwner(person);
    }

    public PersonEmailAddress(@Nonnull Person person, @Nullable IEmailAddressType iEmailAddressType, @Nonnull String string) {
        super(iEmailAddressType, string);
        this.setOwner(person);
    }

    public PersonEmailAddress(@Nonnull Person person, @Nullable IEmailAddressType iEmailAddressType, @Nonnull String string, @Nullable String string2) {
        super(iEmailAddressType, string, string2);
        this.setOwner(person);
    }

    @Nullable
    public final Person getOwner() {
        return this.m_aOwner;
    }

    public final void setOwner(@Nonnull Person person) {
        ValueEnforcer.notNull(person, "Owner");
        this.m_aOwner = person;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        PersonEmailAddress personEmailAddress = (PersonEmailAddress)object;
        return EqualsHelper.equals(this.m_aOwner, personEmailAddress.m_aOwner);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aOwner).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("owner", this.m_aOwner).getToString();
    }
}

