/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.person.ESalutation;
import com.helger.masterdata.person.IPersonName;
import com.helger.masterdata.person.PersonNameHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersonName
implements IPersonName {
    private ESalutation m_eSalutation;
    private String m_sPrefixTitle;
    private String m_sFirstName;
    private String m_sMiddleName;
    private String m_sLastName;
    private String m_sSuffixTitle;

    public PersonName() {
    }

    public PersonName(@Nonnull PersonName personName) {
        ValueEnforcer.notNull(personName, "Base");
        this.m_eSalutation = personName.m_eSalutation;
        this.m_sPrefixTitle = personName.m_sPrefixTitle;
        this.m_sFirstName = personName.m_sFirstName;
        this.m_sMiddleName = personName.m_sMiddleName;
        this.m_sLastName = personName.m_sLastName;
        this.m_sSuffixTitle = personName.m_sSuffixTitle;
    }

    public PersonName(@Nonnull IPersonName iPersonName, @Nonnull Locale locale) {
        ValueEnforcer.notNull(iPersonName, "Base");
        this.setSalutation(iPersonName.getSalutation());
        this.setPrefixTitle(iPersonName.getPrefixTitle());
        this.setFirstName(iPersonName.getFirstName(), locale);
        this.setMiddleName(iPersonName.getMiddleName(), locale);
        this.setLastName(iPersonName.getLastName(), locale);
        this.setSuffixTitle(iPersonName.getSuffixTitle());
    }

    public PersonName(@Nullable ESalutation eSalutation, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nonnull Locale locale) {
        this.setSalutation(eSalutation);
        this.setPrefixTitle(string);
        this.setFirstName(string2, locale);
        this.setMiddleName(string3, locale);
        this.setLastName(string4, locale);
        this.setSuffixTitle(string5);
    }

    @Override
    @Nullable
    public ESalutation getSalutation() {
        return this.m_eSalutation;
    }

    @Nonnull
    public EChange setSalutation(@Nullable ESalutation eSalutation) {
        if (EqualsHelper.equals(this.m_eSalutation, eSalutation)) {
            return EChange.UNCHANGED;
        }
        this.m_eSalutation = eSalutation;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getPrefixTitle() {
        return this.m_sPrefixTitle;
    }

    @Nonnull
    public EChange setPrefixTitle(@Nullable String string) {
        String string2 = string;
        if (EqualsHelper.equals(this.m_sPrefixTitle, string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sPrefixTitle = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getFirstName() {
        return this.m_sFirstName;
    }

    @Nonnull
    public EChange setFirstName(@Nullable String string, @Nonnull Locale locale) {
        String string2 = PersonNameHelper.unifyName(string, locale);
        if (EqualsHelper.equals(this.m_sFirstName, string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sFirstName = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getMiddleName() {
        return this.m_sMiddleName;
    }

    @Nonnull
    public EChange setMiddleName(@Nullable String string, @Nonnull Locale locale) {
        String string2 = PersonNameHelper.unifyName(string, locale);
        if (EqualsHelper.equals(this.m_sMiddleName, string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sMiddleName = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getLastName() {
        return this.m_sLastName;
    }

    @Nonnull
    public EChange setLastName(@Nullable String string, @Nonnull Locale locale) {
        String string2 = PersonNameHelper.unifyName(string, locale);
        if (EqualsHelper.equals(this.m_sLastName, string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sLastName = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getSuffixTitle() {
        return this.m_sSuffixTitle;
    }

    @Nonnull
    public EChange setSuffixTitle(@Nullable String string) {
        String string2 = string;
        if (EqualsHelper.equals(this.m_sSuffixTitle, string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sSuffixTitle = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public PersonName getClone() {
        return new PersonName(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PersonName personName = (PersonName)object;
        return EqualsHelper.equals(this.m_eSalutation, personName.m_eSalutation) && EqualsHelper.equals(this.m_sPrefixTitle, personName.m_sPrefixTitle) && EqualsHelper.equals(this.m_sFirstName, personName.m_sFirstName) && EqualsHelper.equals(this.m_sMiddleName, personName.m_sMiddleName) && EqualsHelper.equals(this.m_sLastName, personName.m_sLastName) && EqualsHelper.equals(this.m_sSuffixTitle, personName.m_sSuffixTitle);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eSalutation)).append(this.m_sPrefixTitle).append(this.m_sFirstName).append(this.m_sMiddleName).append(this.m_sLastName).append(this.m_sSuffixTitle).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("salutation", this.m_eSalutation).appendIfNotNull("prefixTitle", this.m_sPrefixTitle).appendIfNotNull("firstName", this.m_sFirstName).appendIfNotNull("middleName", this.m_sMiddleName).appendIfNotNull("lastName", this.m_sLastName).appendIfNotNull("suffixTitle", this.m_sSuffixTitle).getToString();
    }
}

