/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemHelper;
import com.helger.masterdata.person.ESalutation;
import com.helger.masterdata.person.PersonName;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PersonNameMicroTypeConverter
implements IMicroTypeConverter<PersonName> {
    protected static final IMicroQName ATTR_SALUTATION = new MicroQName("salutation");
    protected static final IMicroQName ATTR_PREFIXTITLE = new MicroQName("prefixtitle");
    protected static final IMicroQName ATTR_FIRSTNAME = new MicroQName("firstname");
    protected static final IMicroQName ATTR_MIDDLENAME = new MicroQName("middlename");
    protected static final IMicroQName ATTR_LASTNAME = new MicroQName("lastname");
    protected static final IMicroQName ATTR_SUFFIXTITLE = new MicroQName("suffixtitle");

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull PersonName personName, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        if (personName.getSalutation() != null) {
            microElement.setAttribute(ATTR_SALUTATION, personName.getSalutationID());
        }
        if (StringHelper.hasText(personName.getPrefixTitle())) {
            microElement.setAttribute(ATTR_PREFIXTITLE, personName.getPrefixTitle());
        }
        if (StringHelper.hasText(personName.getFirstName())) {
            microElement.setAttribute(ATTR_FIRSTNAME, personName.getFirstName());
        }
        if (StringHelper.hasText(personName.getMiddleName())) {
            microElement.setAttribute(ATTR_MIDDLENAME, personName.getMiddleName());
        }
        if (StringHelper.hasText(personName.getLastName())) {
            microElement.setAttribute(ATTR_LASTNAME, personName.getLastName());
        }
        if (StringHelper.hasText(personName.getSuffixTitle())) {
            microElement.setAttribute(ATTR_SUFFIXTITLE, personName.getSuffixTitle());
        }
        return microElement;
    }

    @Override
    @Nonnull
    public PersonName convertToNative(@Nonnull IMicroElement iMicroElement) {
        Locale locale = SystemHelper.getSystemLocale();
        PersonName personName = new PersonName();
        personName.setSalutation(ESalutation.getFromIDOrNull(iMicroElement.getAttributeValue(ATTR_SALUTATION)));
        personName.setPrefixTitle(iMicroElement.getAttributeValue(ATTR_PREFIXTITLE));
        personName.setFirstName(iMicroElement.getAttributeValue(ATTR_FIRSTNAME), locale);
        personName.setMiddleName(iMicroElement.getAttributeValue(ATTR_MIDDLENAME), locale);
        personName.setLastName(iMicroElement.getAttributeValue(ATTR_LASTNAME), locale);
        personName.setSuffixTitle(iMicroElement.getAttributeValue(ATTR_SUFFIXTITLE));
        return personName;
    }
}

