/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.postal;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.postal.IPostalCodeCountry;
import com.helger.masterdata.postal.PostalCodeFormat;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PostalCodeCountry
implements IPostalCodeCountry {
    private final String m_sISO;
    private final ICommonsList<PostalCodeFormat> m_aFormats = new CommonsArrayList<PostalCodeFormat>();
    private final ICommonsList<String> m_aSpecificPostalCodes = new CommonsArrayList<String>();
    private String m_sNote;

    public PostalCodeCountry(@Nonnull @Nonempty String string) {
        this.m_sISO = ValueEnforcer.notEmpty(string, "ISO");
    }

    @Override
    @Nonnull
    @Nonempty
    public String getISO() {
        return this.m_sISO;
    }

    void addFormat(@Nonnull PostalCodeFormat postalCodeFormat) {
        ValueEnforcer.notNull(postalCodeFormat, "Format");
        this.m_aFormats.add(postalCodeFormat);
    }

    @Override
    @Nonnegative
    public int getFormatCount() {
        return this.m_aFormats.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PostalCodeFormat> getAllFormats() {
        return (ICommonsList)this.m_aFormats.getClone();
    }

    @Override
    @Nullable
    public PostalCodeFormat getFormatOfIndex(int n) {
        return (PostalCodeFormat)this.m_aFormats.getAtIndex(n);
    }

    void addSpecificPostalCode(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "SpecificPostalCode");
        ValueEnforcer.isTrue(this.isValidPostalCode(string), () -> "The passed code '" + string + "' is not valid according to the rules!");
        this.m_aSpecificPostalCodes.add(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllSpecificPostalCodes() {
        return (ICommonsList)this.m_aSpecificPostalCodes.getClone();
    }

    @Override
    @Nonnegative
    public int getSpecificPostalCodeCount() {
        return this.m_aSpecificPostalCodes.size();
    }

    void setNote(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Note");
        this.m_sNote = string;
    }

    @Override
    @Nullable
    public String getNote() {
        return this.m_sNote;
    }

    @Override
    public boolean isValidPostalCode(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (PostalCodeFormat postalCodeFormat : this.m_aFormats) {
                if (!postalCodeFormat.isValidPostalCode(string)) continue;
                return true;
            }
        }
        return this.m_aFormats.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllExamples() {
        return this.m_aFormats.getAllMapped(PostalCodeFormat::getExample);
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISO", this.m_sISO).append("formats", this.m_aFormats).append("specificPostalCodes", this.m_aSpecificPostalCodes).appendIfNotNull("note", this.m_sNote).getToString();
    }
}

