/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.price;

import com.helger.masterdata.currency.IHasCurrency;
import com.helger.masterdata.currencyvalue.ICurrencyValue;
import com.helger.masterdata.vat.IHasVATItem;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface IPrice
extends IHasCurrency,
IHasVATItem,
Serializable {
    @Nonnull
    public ICurrencyValue getNetAmount();

    @Nonnull
    default public BigDecimal getNetValue() {
        return this.getNetAmount().getValue();
    }

    @Nonnull
    default public ICurrencyValue getGrossAmount() {
        return this.getNetAmount().getMultiplied(this.getVATItem().getMultiplicationFactorNetToGross());
    }

    @Nonnull
    default public BigDecimal getGrossValue() {
        return this.getGrossAmount().getValue();
    }

    @Nonnull
    default public ICurrencyValue getTaxAmount() {
        return this.getNetAmount().getMultiplied(this.getVATItem().getPercentageFactor());
    }

    @Nonnull
    default public BigDecimal getTaxValue() {
        return this.getTaxAmount().getValue();
    }

    @Nonnull
    @CheckReturnValue
    public IPrice getAdded(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    public IPrice getAdded(long var1);

    @Nonnull
    @CheckReturnValue
    public IPrice getSubtracted(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    public IPrice getSubtracted(long var1);

    @Nonnull
    @CheckReturnValue
    public IPrice getMultiplied(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    public IPrice getMultiplied(long var1);

    @Nonnull
    @CheckReturnValue
    public IPrice getDivided(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    public IPrice getDivided(long var1);
}

