/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.price;

import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.price.Price;
import com.helger.masterdata.vat.IVATItem;
import com.helger.masterdata.vat.VATManager;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PriceMicroTypeConverter
implements IMicroTypeConverter<Price> {
    private static final IMicroQName ATTR_CURRENCY = new MicroQName("currency");
    private static final IMicroQName ATTR_NETAMOUNT = new MicroQName("netamount");
    private static final IMicroQName ATTR_GROSSAMOUNT = new MicroQName("grossamount");
    private static final IMicroQName ATTR_VATITEM = new MicroQName("vatitem");

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull Price price, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_CURRENCY, price.getCurrency().getID());
        microElement.setAttributeWithConversion(ATTR_NETAMOUNT, (Object)price.getNetAmount().getValue());
        microElement.setAttributeWithConversion(ATTR_GROSSAMOUNT, (Object)price.getGrossAmount().getValue());
        microElement.setAttribute(ATTR_VATITEM, price.getVATItemID());
        return microElement;
    }

    @Override
    @Nonnull
    public Price convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_CURRENCY);
        ECurrency eCurrency = ECurrency.getFromIDOrNull(string);
        if (eCurrency == null) {
            throw new IllegalStateException("Failed to resolve currency with ID '" + string + "'");
        }
        BigDecimal bigDecimal = iMicroElement.getAttributeValueWithConversion(ATTR_NETAMOUNT, BigDecimal.class);
        String string2 = iMicroElement.getAttributeValue(ATTR_VATITEM);
        IVATItem iVATItem = VATManager.getDefaultInstance().getVATItemOfID(string2);
        if (iVATItem == null) {
            throw new IllegalStateException("Failed to resolve VAT item with ID '" + string2 + "'");
        }
        return new Price(eCurrency, bigDecimal, iVATItem);
    }
}

