/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.swift;

import com.helger.commons.regex.RegExCache;
import com.helger.commons.string.StringHelper;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.RegEx;

public final class BICManager {
    public static final int BIC_LENGTH_MIN = 8;
    public static final int BIC_LENGTH_MAX = 11;
    public static final String BIC_SUFFIX_MIN_TO_MAX = "XXX";
    @RegEx
    public static final String BIC_PATTERN = "(?i)^[a-z]{6}[a-z0-9]{2}([a-z0-9]{3})?$";
    private static final Pattern s_aBICPattern = RegExCache.getPattern("(?i)^[a-z]{6}[a-z0-9]{2}([a-z0-9]{3})?$");
    private static final BICManager s_aInstance = new BICManager();

    private BICManager() {
    }

    public static boolean isValidBIC(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return s_aBICPattern.matcher(string).matches();
    }

    public static boolean isPassiveBICParticipant(@Nullable String string) {
        return BICManager.isValidBIC(string) && string.charAt(7) == '1';
    }

    public static boolean isTestBIC(@Nullable String string) {
        return BICManager.isValidBIC(string) && string.charAt(7) == '0';
    }
}

