/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.swift;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.swift.IBANCountryData;
import com.helger.masterdata.swift.IBANElementValue;
import com.helger.masterdata.swift.IBANManager;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IBAN
implements Serializable {
    private final ICommonsList<IBANElementValue> m_aValues;

    public IBAN(@Nonnull List<IBANElementValue> list) {
        ValueEnforcer.notNull(list, "Values");
        this.m_aValues = new CommonsArrayList<List<IBANElementValue>>(list);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IBANElementValue> getAllValues() {
        return (ICommonsList)this.m_aValues.getClone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        IBAN iBAN = (IBAN)object;
        return this.m_aValues.equals(iBAN.m_aValues);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aValues)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("values", this.m_aValues).getToString();
    }

    @Nonnull
    public static String extractCountryCode(@Nonnull String string) {
        return string.substring(0, 2);
    }

    @Nullable
    public static IBAN createFromString(@Nullable String string) {
        String string2 = IBANManager.unifyIBAN(string);
        if (StringHelper.hasNoText(string2)) {
            return null;
        }
        String string3 = IBAN.extractCountryCode(string2);
        IBANCountryData iBANCountryData = IBANManager.getCountryData(string3);
        if (iBANCountryData == null) {
            throw new IllegalArgumentException("Passed IBAN country '" + string3 + "' is not supported!");
        }
        return new IBAN(iBANCountryData.parseToElementValues(string2));
    }
}

